/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.adminp;

import jakarta.annotation.Resource;
import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.RunAs;
import jakarta.ejb.LocalBean;
import jakarta.ejb.SessionContext;
import jakarta.ejb.Stateless;
import jakarta.ejb.TransactionAttribute;
import jakarta.ejb.TransactionAttributeType;
import jakarta.inject.Inject;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.adminp.AdminPException;
import org.imixs.workflow.engine.adminp.JobHandler;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.InvalidAccessException;
import org.imixs.workflow.exceptions.QueryException;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RunAs(value="org.imixs.ACCESSLEVEL.MANAGERACCESS")
@Stateless
@LocalBean
public class JobHandlerRenameUser
implements JobHandler {
    @Resource
    SessionContext ctx;
    @Inject
    DocumentService documentService;
    private static final int DEFAULT_COUNT = 100;
    private static Logger logger = Logger.getLogger(JobHandlerRenameUser.class.getName());

    @Override
    public ItemCollection run(ItemCollection adminp) throws AdminPException {
        List<ItemCollection> col;
        long lProfiler = System.currentTimeMillis();
        int iIndex = adminp.getItemValueInteger("numIndex");
        int iBlockSize = adminp.getItemValueInteger("numBlockSize");
        if (iBlockSize <= 0) {
            iBlockSize = 100;
            adminp.replaceItemValue("numBlockSize", (Object)iBlockSize);
        }
        Date datFilterFrom = adminp.getItemValueDate("datfrom");
        Date datFilterTo = adminp.getItemValueDate("datto");
        int iUpdates = adminp.getItemValueInteger("numUpdates");
        int iProcessed = adminp.getItemValueInteger("numProcessed");
        String fromUserID = adminp.getItemValueString("namFrom").trim();
        String toUserID = adminp.getItemValueString("namTo").trim();
        boolean replace = adminp.getItemValueBoolean("keyReplace");
        if (fromUserID.isEmpty() || toUserID.isEmpty()) {
            throw new AdminPException("INVALID_PARAMS", "Invalid job configuration - attributes 'namFrom' or 'namTo' are empty.");
        }
        String summary = "Rename: " + fromUserID + " -> " + toUserID + " (replace=" + replace + ")";
        logger.info(summary);
        adminp.replaceItemValue("$WorkflowSummary", (Object)summary);
        String typeFilter = adminp.getItemValueString("typelist");
        if (typeFilter.isEmpty()) {
            typeFilter = "workitem";
        }
        Object sQuery = "(";
        List<String> typeList = Arrays.asList(typeFilter.split("\\s*,\\s*"));
        for (String aValue : typeList) {
            sQuery = (String)sQuery + "type:\"" + aValue.trim() + "\" OR ";
        }
        sQuery = ((String)sQuery).substring(0, ((String)sQuery).length() - 4);
        sQuery = (String)sQuery + ")";
        sQuery = (String)sQuery + " AND ($writeaccess:\"" + fromUserID + "\" OR $readaccess:\"" + fromUserID + "\" OR owner:\"" + fromUserID + "\" OR namowner:\"" + fromUserID + "\")";
        if (datFilterFrom != null && datFilterTo != null) {
            SimpleDateFormat luceneFormat = new SimpleDateFormat("yyyyMMdd");
            sQuery = (String)sQuery + " AND ($created:[" + luceneFormat.format(datFilterFrom) + " TO " + luceneFormat.format(datFilterTo) + "])";
        }
        adminp.replaceItemValue("txtQuery", sQuery);
        try {
            col = this.documentService.find((String)sQuery, iBlockSize, iIndex, "$created", false);
        }
        catch (QueryException e) {
            throw new InvalidAccessException("INVALID_ID", e.getMessage(), (Exception)((Object)e));
        }
        int colSize = col.size();
        for (ItemCollection entity : col) {
            ++iProcessed;
            boolean result = ((JobHandlerRenameUser)this.ctx.getBusinessObject(JobHandlerRenameUser.class)).updateWorkitemUserIds(entity, fromUserID, toUserID, replace);
            if (!result) continue;
            ++iUpdates;
        }
        adminp.replaceItemValue("numUpdates", (Object)iUpdates);
        adminp.replaceItemValue("numProcessed", (Object)iProcessed);
        adminp.replaceItemValue("numLastCount", (Object)col.size());
        adminp.replaceItemValue("numIndex", (Object)(++iIndex));
        long time = (System.currentTimeMillis() - lProfiler) / 1000L;
        if (time == 0L) {
            time = 1L;
        }
        logger.info("Job RENAME_USER (" + adminp.getUniqueID() + ") - " + colSize + " documents processed, " + iUpdates + " updates in " + time + " sec.  (in total: " + iProcessed + " processed, " + iUpdates + " updates)");
        if (colSize < iBlockSize) {
            adminp.replaceItemValue("iscompleted", (Object)true);
        }
        return adminp;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public boolean updateWorkitemUserIds(ItemCollection entity, String from, String to, boolean replace) throws AccessDeniedException {
        boolean bUpdate = false;
        if (entity == null) {
            return false;
        }
        if (entity.getItemValueBoolean("$immutable")) {
            return false;
        }
        if (entity.getItemValueBoolean("private")) {
            return false;
        }
        if (this.updateList(entity.getItemValue("$readaccess"), from, to, replace)) {
            bUpdate = true;
        }
        if (this.updateList(entity.getItemValue("$writeaccess"), from, to, replace)) {
            bUpdate = true;
        }
        if (this.updateList(entity.getItemValue("$owner"), from, to, replace)) {
            bUpdate = true;
        }
        if (this.updateList(entity.getItemValue("namOwner"), from, to, replace)) {
            bUpdate = true;
        }
        if (bUpdate) {
            String summary = "Rename: " + from + " -> " + to + " (replace=" + replace + ")";
            entity.appendItemValue("txtAdminpLog", (Object)(new Date(System.currentTimeMillis()) + " " + summary));
            this.documentService.save(entity);
            logger.finest("......updated: " + entity.getItemValueString("$uniqueid"));
        }
        return bUpdate;
    }

    private boolean updateList(List list, String from, String to, boolean replace) {
        boolean update = false;
        if (list == null || list.isEmpty()) {
            return false;
        }
        if (list.contains(from)) {
            if (to != null && !"".equals(to) && !list.contains(to)) {
                list.add(to);
                update = true;
            }
            if (replace) {
                while (list.contains(from)) {
                    list.remove(from);
                    update = true;
                }
            }
        }
        return update;
    }
}

