/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.plugins;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.engine.plugins.ResultPlugin;
import org.imixs.workflow.exceptions.PluginException;

public class AnalysisPlugin
extends AbstractPlugin {
    public static final String INVALID_FORMAT = "INVALID_FORMAT";
    private static Logger logger = Logger.getLogger(AnalysisPlugin.class.getName());

    public ItemCollection run(ItemCollection documentContext, ItemCollection documentActivity) throws PluginException {
        String sActivityResult = documentActivity.getItemValueString("txtActivityResult");
        List<MeasurePoint> measurePoints = this.evaluate(sActivityResult, documentContext);
        for (MeasurePoint point : measurePoints) {
            List valuesStop;
            List valuesStart;
            if ("start".equals(point.type)) {
                valuesStart = documentContext.getItemValue("datMeasurePointStart_" + point.name);
                valuesStop = documentContext.getItemValue("datMeasurePointStop_" + point.name);
                if (valuesStart.size() != valuesStop.size()) {
                    logger.warning("[AnalysisPlugin] Wrong measure point '" + point.name + "' starttime without stoptime! - please check model entry " + documentActivity.getItemValueInteger("numProcessID") + "." + documentActivity.getItemValueInteger("numActivityID") + " measurepoint will be ignored!");
                    continue;
                }
                valuesStart.add(0, new Date());
                documentContext.replaceItemValue("datMeasurePointStart_" + point.name, (Object)valuesStart);
            }
            if (!"stop".equals(point.type)) continue;
            valuesStart = documentContext.getItemValue("datMeasurePointStart_" + point.name);
            valuesStop = documentContext.getItemValue("datMeasurePointStop_" + point.name);
            if (valuesStop.size() != valuesStart.size() - 1) {
                logger.warning("[AnalysisPlugin] Wrong measure point '" + point.name + "' stoptime without starttime! - please check model entry " + documentActivity.getItemValueInteger("numProcessID") + "." + documentActivity.getItemValueInteger("numActivityID") + " measurepoint will be ignored!");
                continue;
            }
            valuesStop.add(0, new Date());
            documentContext.replaceItemValue("datMeasurePointStop_" + point.name, (Object)valuesStop);
            int numTotal = documentContext.getItemValueInteger("numMeasurePoint_" + point.name);
            Date start = (Date)valuesStart.get(0);
            Date stop = (Date)valuesStop.get(0);
            long lStart = start.getTime() / 1000L;
            long lStop = stop.getTime() / 1000L;
            numTotal = (int)((long)numTotal + (lStop - lStart));
            documentContext.replaceItemValue("numMeasurePoint_" + point.name, (Object)numTotal);
        }
        return documentContext;
    }

    public List<MeasurePoint> evaluate(String aString, ItemCollection documentContext) throws PluginException {
        int iTagStartPos;
        String sName = "";
        String sType = " ";
        ArrayList<MeasurePoint> result = new ArrayList<MeasurePoint>();
        if (aString == null || ((String)aString).isEmpty()) {
            return result;
        }
        while ((iTagStartPos = ((String)aString).toLowerCase().indexOf("<item")) != -1) {
            int iTagEndPos = ((String)aString).toLowerCase().indexOf("</item>", iTagStartPos);
            if (iTagEndPos == -1) {
                throw new PluginException(ResultPlugin.class.getSimpleName(), INVALID_FORMAT, "</item>  expected!");
            }
            int iContentStartPos = 0;
            int iContentEndPos = 0;
            int iNameStartPos = 0;
            int iNameEndPos = 0;
            int iTypeStartPos = 0;
            int iTypeEndPos = 0;
            sName = "";
            sType = " ";
            String sItemValue = "";
            iContentEndPos = iTagEndPos;
            String sTestString = ((String)aString).substring(0, iContentEndPos);
            iContentStartPos = sTestString.lastIndexOf(62) + 1;
            if (iContentStartPos >= iContentEndPos) {
                return result;
            }
            iTagEndPos += "</item>".length();
            iNameStartPos = ((String)aString).toLowerCase().indexOf("name=", iTagStartPos);
            if (iNameStartPos > -1 && iNameStartPos < iContentStartPos) {
                String sNamePart = ((String)aString).substring(0, iContentStartPos);
                sNamePart = sNamePart.replace("'", "\"");
                iNameStartPos = sNamePart.indexOf("\"", iNameStartPos) + 1;
                iNameEndPos = sNamePart.indexOf("\"", iNameStartPos + 1);
                sName = sNamePart.substring(iNameStartPos, iNameEndPos);
                sName = sName.toLowerCase();
            }
            if ((iTypeStartPos = ((String)aString).toLowerCase().indexOf("type=", iTagStartPos)) > -1 && iTypeStartPos < iContentStartPos) {
                String sTypePart = ((String)aString).substring(0, iContentStartPos);
                sTypePart = sTypePart.replace("'", "\"");
                iTypeStartPos = sTypePart.indexOf("\"", iTypeStartPos) + 1;
                iTypeEndPos = sTypePart.indexOf("\"", iTypeStartPos + 1);
                sType = sTypePart.substring(iTypeStartPos, iTypeEndPos);
                sType = sType.toLowerCase();
            }
            sItemValue = ((String)aString).substring(iContentStartPos, iContentEndPos);
            if ("measurepoint".equals(sName) && ("start".equals(sType) || "stop".equals(sType))) {
                MeasurePoint point = new MeasurePoint(sItemValue.toLowerCase(), sType);
                result.add(point);
            }
            aString = ((String)aString).substring(0, iTagStartPos) + ((String)aString).substring(iTagEndPos);
        }
        return result;
    }

    private class MeasurePoint {
        public String name;
        public String type;

        public MeasurePoint(String name, String type) {
            this.name = name;
            this.type = type;
        }
    }
}

