/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.plugins;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Marshaller;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Logger;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.xml.XMLDataCollection;
import org.imixs.workflow.xml.XMLDocument;
import org.imixs.workflow.xml.XMLDocumentAdapter;
import org.imixs.workflow.xml.XSLHandler;

public class ReportPlugin
extends AbstractPlugin {
    public static final String INVALID_CONTEXT = "INVALID_CONTEXT";
    public static final String REPORT_UNDEFINED = "REPORT_UNDEFINED";
    public static final String INVALID_REPORT_DEFINITION = "INVALID_REPORT_DEFINITION";
    private static Logger logger = Logger.getLogger(ReportPlugin.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemCollection run(ItemCollection adocumentContext, ItemCollection adocumentActivity) throws PluginException {
        String encoding;
        String reportName = adocumentActivity.getItemValueString("txtReportName");
        String reportFilePath = adocumentActivity.getItemValueString("txtReportFilePath");
        if ("".equals(reportFilePath)) {
            reportFilePath = reportName;
        }
        reportFilePath = this.getWorkflowService().adaptText(reportFilePath, adocumentContext);
        String reportTarget = adocumentActivity.getItemValueString("txtReportTarget");
        if ("".equals(reportName)) {
            return adocumentContext;
        }
        ItemCollection itemCol = this.getWorkflowService().getReportService().findReport(reportName);
        if (itemCol == null) {
            throw new PluginException(ReportPlugin.class.getSimpleName(), REPORT_UNDEFINED, "Report '" + reportName + " is undefined", new Object[]{reportName});
        }
        String xslTemplate = itemCol.getItemValueString("xsl").trim();
        if ("".equals(xslTemplate)) {
            return adocumentContext;
        }
        String sContentType = itemCol.getItemValueString("contenttype");
        if ("".equals(sContentType)) {
            sContentType = "text/html";
        }
        if ("".equals(encoding = itemCol.getItemValueString("encoding"))) {
            encoding = "UTF-8";
        }
        try {
            XMLDocument xml = XMLDocumentAdapter.getDocument((ItemCollection)adocumentContext);
            StringWriter writer = new StringWriter();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{XMLDataCollection.class});
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.encoding", (Object)encoding);
            m.marshal((Object)xml, (Writer)writer);
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                if ("application/pdf".equals(sContentType.toLowerCase())) {
                    logger.warning("FOP Transformation is not yet implementd");
                } else {
                    XSLHandler.transform((String)writer.toString(), (String)xslTemplate, (String)encoding, (OutputStream)outputStream);
                }
            }
            if (reportTarget.isEmpty() || "0".equals(reportTarget)) {
                FileData fileData = new FileData(reportFilePath, outputStream.toByteArray(), sContentType, null);
                adocumentContext.addFileData(fileData);
            }
            if ("1".equals(reportTarget)) {
                logger.warning("Writing into BlobWorkitem is no longer supported - please use the DMSPlugin for transfer");
            }
            if ("2".equals(reportTarget)) {
                try (FileOutputStream fos = null;){
                    fos = new FileOutputStream(reportFilePath);
                    fos.write(outputStream.toByteArray());
                    fos.flush();
                }
            }
            return adocumentContext;
        }
        catch (Exception e) {
            throw new PluginException(ReportPlugin.class.getSimpleName(), INVALID_REPORT_DEFINITION, "Unable to process report '" + reportName + "' ", new Object[]{reportName});
        }
    }

    public void close(int status) throws PluginException {
    }
}

