/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.RunAs;
import jakarta.ejb.Singleton;
import jakarta.ejb.Startup;
import jakarta.ejb.Timeout;
import jakarta.ejb.Timer;
import jakarta.ejb.TimerConfig;
import jakarta.ejb.TimerService;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.workflow.engine.AsyncEventService;
import org.imixs.workflow.engine.EventLogService;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RunAs(value="org.imixs.ACCESSLEVEL.MANAGERACCESS")
@Startup
@Singleton
public class AsyncEventScheduler {
    public static final String ASYNCEVENT_PROCESSOR_ENABLED = "asyncevent.processor.enabled";
    public static final String ASYNCEVENT_PROCESSOR_INTERVAL = "asyncevent.processor.interval";
    public static final String ASYNCEVENT_PROCESSOR_INITIALDELAY = "asyncevent.processor.initialdelay";
    public static final String ASYNCEVENT_PROCESSOR_DEADLOCK = "asyncevent.processor.deadlock";
    public static final String EVENTLOG_TOPIC_ASYNC_EVENT = "async.event";
    @Inject
    @ConfigProperty(name="asyncevent.processor.enabled", defaultValue="false")
    boolean enabled;
    @Inject
    @ConfigProperty(name="asyncevent.processor.interval", defaultValue="1000")
    long interval;
    @Inject
    @ConfigProperty(name="asyncevent.processor.initialdelay", defaultValue="0")
    long initialDelay;
    @Inject
    @ConfigProperty(name="asyncevent.processor.deadlock", defaultValue="60000")
    long deadLockInterval;
    private static Logger logger = Logger.getLogger(AsyncEventScheduler.class.getName());
    @Resource
    TimerService timerService;
    @Inject
    AsyncEventService asyncEventService;
    @Inject
    EventLogService eventLogService;

    @PostConstruct
    public void init() {
        if (this.enabled) {
            logger.info("Starting AsyncEventScheduler - initalDelay=" + this.initialDelay + "  inverval=" + this.interval + " ....");
            TimerConfig timerConfig = new TimerConfig();
            timerConfig.setInfo((Serializable)((Object)"Imixs-Workflow AsyncEventScheduler"));
            timerConfig.setPersistent(false);
            this.timerService.createIntervalTimer(this.initialDelay, this.interval, timerConfig);
        }
    }

    @Timeout
    public void run(Timer timer) {
        this.eventLogService.releaseDeadLocks(this.deadLockInterval, EVENTLOG_TOPIC_ASYNC_EVENT);
        this.asyncEventService.processEventLog();
    }
}

