/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.plugins;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.exceptions.QueryException;

public class VersionPlugin
extends AbstractPlugin {
    public static final String INVALID_CONTEXT = "INVALID_CONTEXT";
    public static final String INVALID_WORKITEM = "INVALID_WORKITEM";
    private String versionMode = "";
    private int versionActivityID = -1;
    private ItemCollection version = null;
    private ItemCollection documentContext = null;
    private static final String PROCESSING_VERSION_ATTRIBUTE = "$processingversion";
    private static Logger logger = Logger.getLogger(VersionPlugin.class.getName());

    public ItemCollection getVersion() {
        return this.version;
    }

    public void setVersion(ItemCollection version) {
        this.version = version;
    }

    public ItemCollection run(ItemCollection adocumentContext, ItemCollection adocumentActivity) throws PluginException {
        boolean debug = logger.isLoggable(Level.FINE);
        this.documentContext = adocumentContext;
        this.versionMode = adocumentActivity.getItemValueString("keyVersion");
        this.versionActivityID = adocumentActivity.getItemValueInteger("numVersionActivityID");
        try {
            if ("1".equals(this.versionMode)) {
                this.version = this.createVersion(this.documentContext);
                if (debug) {
                    logger.fine("...... new version created");
                }
                if (this.versionActivityID > 0) {
                    this.version.replaceItemValue("$ActivityID", (Object)this.versionActivityID);
                    this.version.replaceItemValue(PROCESSING_VERSION_ATTRIBUTE, (Object)true);
                    this.version = this.getWorkflowService().processWorkItem(this.version);
                } else {
                    this.version = this.getWorkflowService().getDocumentService().save(this.version);
                }
                return this.documentContext;
            }
            if ("2".equals(adocumentActivity.getItemValueString("keyVersion"))) {
                String sworkitemID = this.documentContext.getItemValueString("$WorkItemID");
                String searchTerm = "($workitemid:\"" + sworkitemID + "\")";
                List<ItemCollection> col = this.getWorkflowService().getDocumentService().find(searchTerm, 0, -1);
                for (ItemCollection aVersion : col) {
                    String sWorkitemRef = aVersion.getItemValueString("$workitemIDRef");
                    if (!"".equals(sWorkitemRef)) continue;
                    String id = this.documentContext.getItemValueString("$uniqueID");
                    aVersion.replaceItemValue("$WorkItemIDRef", (Object)id);
                    if (this.versionActivityID > 0) {
                        aVersion.replaceItemValue("$ActivityID", (Object)this.versionActivityID);
                        aVersion = this.getWorkflowService().processWorkItem(aVersion);
                    } else {
                        aVersion = this.getWorkflowService().getDocumentService().save(aVersion);
                    }
                    this.version = aVersion;
                }
                this.documentContext.removeItem("$WorkItemIDRef");
            }
        }
        catch (AccessDeniedException e) {
            throw new PluginException(e.getErrorContext(), e.getErrorCode(), e.getMessage(), (Exception)((Object)e));
        }
        catch (ProcessingErrorException e) {
            throw new PluginException(e.getErrorContext(), e.getErrorCode(), e.getMessage(), (Exception)((Object)e));
        }
        catch (QueryException e) {
            throw new PluginException(e.getErrorContext(), e.getErrorCode(), e.getMessage(), (Exception)((Object)e));
        }
        catch (ModelException e) {
            throw new PluginException(e.getErrorContext(), e.getErrorCode(), e.getMessage(), (Exception)((Object)e));
        }
        this.documentContext.removeItem(PROCESSING_VERSION_ATTRIBUTE);
        return this.documentContext;
    }

    public static boolean isProcssingVersion(ItemCollection adocumentContext) {
        return adocumentContext.getItemValueBoolean(PROCESSING_VERSION_ATTRIBUTE);
    }

    public ItemCollection createVersion(ItemCollection sourceItemCollection) throws PluginException {
        ItemCollection itemColNewVersion = new ItemCollection();
        itemColNewVersion.replaceAllItems(sourceItemCollection.getAllItems());
        String id = sourceItemCollection.getItemValueString("$uniqueid");
        if ("".equals(id)) {
            throw new PluginException(VersionPlugin.class.getSimpleName(), INVALID_WORKITEM, "Error - unable to create a version from a new workitem!");
        }
        itemColNewVersion.getAllItems().remove("$uniqueid");
        itemColNewVersion.replaceItemValue("$WorkItemIDRef", (Object)id);
        return itemColNewVersion;
    }
}

