/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine;

import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.xml.bind.JAXBException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.xml.transform.TransformerException;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.ItemCollectionComparator;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.QueryException;
import org.imixs.workflow.util.XMLParser;
import org.imixs.workflow.xml.XSLHandler;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
public class ReportService {
    private static Logger logger = Logger.getLogger(ReportService.class.getName());
    @Inject
    DocumentService documentService;
    @Inject
    WorkflowService workflowService;

    public ItemCollection findReport(String reportID) {
        ItemCollection result = null;
        result = this.documentService.load(reportID);
        if (result == null) {
            List<ItemCollection> col;
            String searchTerm = "(type:\"ReportEntity\" AND txtname:\"" + reportID + "\")";
            try {
                col = this.documentService.find(searchTerm, 1, 0);
            }
            catch (QueryException e) {
                logger.severe("findReport - invalid id: " + e.getMessage());
                return null;
            }
            if (col.size() > 0) {
                result = (ItemCollection)col.iterator().next();
            }
        }
        return result;
    }

    public List<ItemCollection> findAllReports() {
        List<ItemCollection> col = this.documentService.getDocumentsByType("ReportEntity");
        Collections.sort(col, new ItemCollectionComparator("txtname", true));
        return col;
    }

    public void updateReport(ItemCollection aReport) throws AccessDeniedException {
        String sReportName;
        ItemCollection oldReport;
        aReport.replaceItemValue("type", (Object)"ReportEntity");
        aReport.replaceItemValue("$snapshot.history", (Object)1);
        String sUniqueID = aReport.getItemValueString("$uniqueID");
        if ("".equals(sUniqueID) && (oldReport = this.findReport(sReportName = aReport.getItemValueString("txtname"))) != null) {
            aReport = this.updateReport(aReport, oldReport);
        }
        this.documentService.save(aReport);
    }

    public List<ItemCollection> getDataSource(ItemCollection reportEntity, int pageSize, int pageIndex, String sortBy, boolean sortReverse, Map<String, String> params) throws QueryException {
        ArrayList<ItemCollection> clonedResult = new ArrayList<ItemCollection>();
        long l = System.currentTimeMillis();
        logger.finest("......executeReport: " + reportEntity.getItemValueString("txtname"));
        String query = reportEntity.getItemValueString("txtquery");
        if (params != null) {
            Set<String> keys = params.keySet();
            Iterator<String> iter = keys.iterator();
            while (iter.hasNext()) {
                String sKeyName = iter.next().toString().trim();
                String sParamValue = params.get(sKeyName);
                if (query.indexOf("{" + sKeyName + "}") > -1) {
                    query = query.replace("{" + sKeyName + "}", sParamValue);
                    logger.finest("......executeReport set param " + sKeyName + "=" + sParamValue);
                    continue;
                }
                if (query.indexOf("?" + sKeyName) <= -1) continue;
                query = query.replace("?" + sKeyName, sParamValue);
                logger.warning("......query definition in Report '" + reportEntity.getItemValueString("txtname") + "' is deprecated! Please replace the param '?" + sKeyName + "' with '{" + sKeyName + "}'");
            }
        }
        query = this.replaceDateString(query);
        logger.finest("......executeReport query=" + query);
        List<ItemCollection> result = this.documentService.find(query, pageSize, pageIndex, sortBy, sortReverse);
        List attributes = reportEntity.getItemValue("attributes");
        ArrayList<String> itemNames = new ArrayList<String>();
        for (List attribute : attributes) {
            itemNames.add((String)attribute.get(0));
        }
        for (ItemCollection entity : result) {
            List<ItemCollection> embeddedChildItems = this.getEmbeddedChildItems(entity, itemNames);
            if (!embeddedChildItems.isEmpty()) {
                for (ItemCollection child : embeddedChildItems) {
                    ItemCollection clone = this.cloneEntity(child, attributes);
                    clonedResult.add(clone);
                }
                continue;
            }
            ItemCollection clone = this.cloneEntity(entity, attributes);
            clonedResult.add(clone);
        }
        logger.fine("...executed report '" + reportEntity.getItemValueString("txtname") + "' in " + (System.currentTimeMillis() - l) + "ms");
        return clonedResult;
    }

    public FileData transformDataSource(ItemCollection report, List<ItemCollection> data, String fileName) throws JAXBException, IOException, TransformerException {
        String encoding;
        String xslTemplate = report.getItemValueString("xsl").trim();
        String sContentType = report.getItemValueString("contenttype");
        if ("".equals(sContentType)) {
            sContentType = "text/xml";
        }
        if ("".equals(encoding = report.getItemValueString("encoding"))) {
            encoding = "UTF-8";
        }
        byte[] _bytes = null;
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            XSLHandler.transform(data, (String)xslTemplate, (String)encoding, (OutputStream)outputStream);
            _bytes = outputStream.toByteArray();
        }
        FileData fileData = new FileData(fileName, _bytes, sContentType, null);
        return fileData;
    }

    public Calendar computeDynamicDate(String xmlDate) {
        String value;
        Calendar cal = Calendar.getInstance();
        Map attributes = XMLParser.findAttributes((String)xmlDate);
        if (attributes.containsKey("MONTH")) {
            value = (String)attributes.get("MONTH");
            if ("ACTUAL_MAXIMUM".equalsIgnoreCase(value)) {
                cal.set(2, cal.getActualMaximum(2));
            } else {
                cal.set(2, Integer.parseInt(value) - 1);
            }
        }
        if (attributes.containsKey("YEAR")) {
            value = (String)attributes.get("YEAR");
            cal.set(1, Integer.parseInt(value));
        }
        if (attributes.containsKey("DAY_OF_MONTH")) {
            value = (String)attributes.get("DAY_OF_MONTH");
            if ("ACTUAL_MAXIMUM".equalsIgnoreCase(value)) {
                cal.set(5, cal.getActualMaximum(5));
            } else {
                cal.set(5, Integer.parseInt(value));
            }
        }
        if (attributes.containsKey("DAY_OF_YEAR")) {
            cal.set(6, Integer.parseInt((String)attributes.get("DAY_OF_YEAR")));
        }
        if (attributes.containsKey("ADD")) {
            value = (String)attributes.get("ADD");
            String[] fieldOffset = value.split(",");
            String field = fieldOffset[0];
            int offset = Integer.parseInt(fieldOffset[1]);
            if ("MONTH".equalsIgnoreCase(field)) {
                cal.add(2, offset);
            } else if ("DAY_OF_MONTH".equalsIgnoreCase(field)) {
                cal.add(5, offset);
            } else if ("DAY_OF_YEAR".equalsIgnoreCase(field)) {
                cal.add(6, offset);
            }
        }
        return cal;
    }

    public String replaceDateString(String content) {
        List dates = XMLParser.findTags((String)content, (String)"date");
        for (String dateString : dates) {
            Calendar cal = this.computeDynamicDate(dateString);
            SimpleDateFormat f = new SimpleDateFormat("yyyyMMdd");
            String dateValue = f.format(cal.getTime());
            content = content.replace(dateString, dateValue);
        }
        return content;
    }

    public String customNumberFormat(String pattern, String locale, double value) {
        DecimalFormat formatter = null;
        Locale _locale = ReportService.getLocaleFromString(locale);
        formatter = _locale != null ? (DecimalFormat)DecimalFormat.getInstance(ReportService.getLocaleFromString(locale)) : (DecimalFormat)DecimalFormat.getInstance();
        formatter.applyPattern(pattern);
        String output = formatter.format(value);
        return output;
    }

    private ItemCollection cloneEntity(ItemCollection entity, List<List<String>> attributes) {
        ItemCollection clone = null;
        if (attributes != null && attributes.size() > 0) {
            clone = new ItemCollection();
            for (List<String> attribute : attributes) {
                String field = attribute.get(0);
                String label = "field";
                if (attribute.size() >= 1) {
                    label = attribute.get(1);
                }
                String convert = "";
                if (attribute.size() >= 2) {
                    convert = attribute.get(2);
                }
                String format = "";
                if (attribute.size() >= 3) {
                    format = attribute.get(3);
                }
                String agregate = "";
                if (attribute.size() >= 4) {
                    agregate = attribute.get(4);
                }
                List<Object> values = entity.getItemValue(field);
                if (!convert.isEmpty()) {
                    values = this.convertItemValue(entity, field, convert);
                }
                if (!format.isEmpty()) {
                    String sLocale = XMLParser.findAttribute((String)format, (String)"locale");
                    List content = XMLParser.findTagValues((String)format, (String)"format");
                    if (content.size() > 0) {
                        format = (String)content.get(0);
                    }
                    List<Object> rawValues = values;
                    values = new ArrayList<Object>();
                    for (Object rawValue : rawValues) {
                        values.add(this.formatObjectValue(rawValue, format, sLocale));
                    }
                }
                clone.replaceItemValue(field, values);
            }
        } else {
            clone = (ItemCollection)entity.clone();
        }
        return clone;
    }

    private ItemCollection updateReport(ItemCollection newReport, ItemCollection oldReport) {
        for (Map.Entry mapEntry : newReport.getAllItems().entrySet()) {
            String sName = mapEntry.getKey().toString();
            Object o = mapEntry.getValue();
            if (!this.isValidAttributeName(sName)) continue;
            oldReport.replaceItemValue(sName, o);
        }
        return oldReport;
    }

    private boolean isValidAttributeName(String aName) {
        if ("$creator".equalsIgnoreCase(aName)) {
            return false;
        }
        if ("namcreator".equalsIgnoreCase(aName)) {
            return false;
        }
        if ("$created".equalsIgnoreCase(aName)) {
            return false;
        }
        if ("$modified".equalsIgnoreCase(aName)) {
            return false;
        }
        if ("$uniqueID".equalsIgnoreCase(aName)) {
            return false;
        }
        return !"$isAuthor".equalsIgnoreCase(aName);
    }

    private String formatObjectValue(Object o, String format, String locale) {
        String singleValue = "";
        Date dateValue = null;
        if (o instanceof Date) {
            dateValue = (Date)o;
        }
        if (o instanceof Calendar) {
            Calendar cal = (Calendar)o;
            dateValue = cal.getTime();
        }
        if (dateValue != null) {
            if (format != null && !"".equals(format)) {
                try {
                    SimpleDateFormat formatter = null;
                    formatter = locale != null && !locale.isEmpty() ? new SimpleDateFormat(format, ReportService.getLocaleFromString(locale)) : new SimpleDateFormat(format);
                    singleValue = formatter.format(dateValue);
                }
                catch (Exception ef) {
                    Logger logger = Logger.getLogger(AbstractPlugin.class.getName());
                    logger.warning("ReportService: Invalid format String '" + format + "'");
                    logger.warning("ReportService: Can not format value - error: " + ef.getMessage());
                    return "" + dateValue;
                }
            } else {
                singleValue = DateFormat.getDateTimeInstance(3, 3).format(dateValue);
            }
        } else if (format.contains("#")) {
            try {
                double d = Double.parseDouble(o.toString());
                singleValue = this.customNumberFormat(format, locale, d);
            }
            catch (IllegalArgumentException e) {
                logger.warning("Format Error (" + format + ") = " + e.getMessage());
                singleValue = "0";
            }
        } else {
            singleValue = o.toString();
        }
        return singleValue;
    }

    private List<Object> convertItemValue(ItemCollection itemcol, String itemName, String converter) {
        if (converter == null || converter.isEmpty()) {
            return itemcol.getItemValue(itemName);
        }
        ArrayList<Object> values = itemcol.getItemValue(itemName);
        if (values.size() == 0) {
            values.add(null);
        }
        List<String> adaptedValueList = null;
        if (converter.startsWith("<") && converter.endsWith(">")) {
            try {
                logger.finest("......converter = " + converter);
                adaptedValueList = this.workflowService.adaptTextList(converter, itemcol);
            }
            catch (PluginException e) {
                logger.warning("Unable to adapt text converter: " + converter);
            }
        }
        if (adaptedValueList != null) {
            values = new ArrayList<Object>();
            values.addAll(adaptedValueList);
        }
        for (int i = 0; i < values.size(); ++i) {
            Object o = values.get(i);
            if (converter.equalsIgnoreCase("double") || converter.equalsIgnoreCase("xs:decimal")) {
                try {
                    double d = 0.0;
                    if (o != null) {
                        d = Double.parseDouble(o.toString());
                    }
                    values.set(i, d);
                }
                catch (NumberFormatException e) {
                    values.set(i, new Double(0.0));
                }
            }
            if (!converter.equalsIgnoreCase("integer") && !converter.equalsIgnoreCase("xs:int")) continue;
            try {
                int d = 0;
                if (o != null) {
                    i = Integer.parseInt(o.toString());
                }
                values.set(i, d);
                continue;
            }
            catch (NumberFormatException e) {
                values.set(i, new Integer(0));
            }
        }
        return values;
    }

    private static Locale getLocaleFromString(String sLocale) {
        Locale locale = null;
        if (sLocale != null && !sLocale.isEmpty()) {
            StringTokenizer stLocale = new StringTokenizer(sLocale, "_");
            if (stLocale.countTokens() == 1) {
                String sLang = stLocale.nextToken();
                String sCount = sLang.toUpperCase();
                locale = new Locale(sLang, sCount);
            } else {
                String sLang = stLocale.nextToken();
                String sCount = stLocale.nextToken();
                locale = new Locale(sLang, sCount);
            }
        }
        return locale;
    }

    private List<ItemCollection> getEmbeddedChildItems(ItemCollection entity, List<String> fieldNames) {
        ArrayList<String> embeddedItemNames = new ArrayList<String>();
        ArrayList<ItemCollection> result = new ArrayList<ItemCollection>();
        for (String field : fieldNames) {
            if (!(field = field.toLowerCase()).contains("~") || embeddedItemNames.contains(field = field.substring(0, field.indexOf(126)))) continue;
            embeddedItemNames.add(field);
        }
        if (!embeddedItemNames.isEmpty()) {
            for (String field : embeddedItemNames) {
                List mapChildItems = entity.getItemValue(field);
                for (Object mapOderItem : mapChildItems) {
                    if (!(mapOderItem instanceof Map)) continue;
                    ItemCollection child = new ItemCollection((Map)mapOderItem);
                    ItemCollection clone = new ItemCollection(entity);
                    Set childFieldNameList = child.getAllItems().keySet();
                    for (String childFieldName : childFieldNameList) {
                        clone.replaceItemValue(field + "~" + childFieldName, (Object)child.getItemValue(childFieldName));
                    }
                    result.add(clone);
                }
            }
        }
        return result;
    }
}

