/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.adapters;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.imixs.workflow.GenericAdapter;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AdapterException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;

@Named
public class AccessAdapter
implements GenericAdapter,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(AccessAdapter.class.getName());
    protected WorkflowService workflowService;

    public AccessAdapter() {
    }

    @Inject
    public AccessAdapter(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public ItemCollection execute(ItemCollection document, ItemCollection event) throws AdapterException {
        ItemCollection nextTask = null;
        try {
            nextTask = this.workflowService.evalNextTask(document);
            this.updateParticipants(document);
            this.updateACL(document, event, nextTask);
        }
        catch (ModelException | PluginException e) {
            throw new AdapterException(AccessAdapter.class.getSimpleName(), e.getErrorCode(), e.getMessage());
        }
        return null;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public ItemCollection updateParticipants(ItemCollection workitem) {
        String user;
        List participants = workitem.getItemValue("$participants");
        if (!participants.contains(user = this.workflowService.getUserName())) {
            participants.add(user);
            workitem.replaceItemValue("$participants", (Object)participants);
        }
        return workitem;
    }

    public ItemCollection updateACL(ItemCollection workitem, ItemCollection event, ItemCollection nextTask) throws PluginException {
        if (event == null && nextTask == null) {
            return workitem;
        }
        ItemCollection documentContext = workitem;
        if (!(event != null && event.getItemValueBoolean("keyupdateacl") || nextTask != null && nextTask.getItemValueBoolean("keyupdateacl"))) {
            return documentContext;
        }
        documentContext.replaceItemValue("$readaccess", new Vector());
        documentContext.replaceItemValue("$writeaccess", new Vector());
        if (event != null && event.getItemValueBoolean("keyupdateacl")) {
            this.updateACLByItemCollection(documentContext, event);
        } else {
            this.updateACLByItemCollection(documentContext, nextTask);
        }
        return documentContext;
    }

    private void updateACLByItemCollection(ItemCollection documentContext, ItemCollection modelEntity) throws PluginException {
        int j;
        boolean debug = logger.isLoggable(Level.FINE);
        if (modelEntity == null || !modelEntity.getItemValueBoolean("keyupdateacl")) {
            return;
        }
        List<?> vectorAccess = documentContext.getItemValue("$readaccess");
        this.mergeRoles(vectorAccess, modelEntity.getItemValue("namaddreadaccess"), documentContext);
        this.mergeFieldList(documentContext, vectorAccess, modelEntity.getItemValue("keyaddreadfields"));
        vectorAccess = this.uniqueList((List<Object>)vectorAccess);
        documentContext.replaceItemValue("$readaccess", vectorAccess);
        if (debug && vectorAccess.size() > 0) {
            logger.finest("......[AccessPlugin] ReadAccess:");
            for (j = 0; j < vectorAccess.size(); ++j) {
                logger.finest("               '" + (String)vectorAccess.get(j) + "'");
            }
        }
        vectorAccess = documentContext.getItemValue("$writeaccess");
        this.mergeRoles(vectorAccess, modelEntity.getItemValue("namaddwriteaccess"), documentContext);
        this.mergeFieldList(documentContext, vectorAccess, modelEntity.getItemValue("keyaddwritefields"));
        vectorAccess = this.uniqueList((List<Object>)vectorAccess);
        documentContext.replaceItemValue("$writeaccess", vectorAccess);
        if (debug && vectorAccess.size() > 0) {
            logger.finest("......[AccessPlugin] WriteAccess:");
            for (j = 0; j < vectorAccess.size(); ++j) {
                logger.finest("               '" + (String)vectorAccess.get(j) + "'");
            }
        }
    }

    public void mergeFieldList(ItemCollection documentContext, List valueList, List<String> fieldList) {
        if (valueList == null || fieldList == null) {
            return;
        }
        List<String> values = null;
        if (fieldList.size() > 0) {
            for (String key : fieldList) {
                if (key == null || (values = (key = key.trim()).startsWith("[") && key.endsWith("]") || key.startsWith("{") && key.endsWith("}") ? Arrays.asList(key.substring(1, key.length() - 1).split("\\s*,\\s*")) : documentContext.getItemValue(key)) == null || values.size() <= 0) continue;
                for (String o : values) {
                    if (valueList.indexOf(o) != -1) continue;
                    valueList.add(o);
                }
            }
        }
    }

    public List<?> uniqueList(List<Object> valueList) {
        int iVectorSize = valueList.size();
        Vector<Object> cleanedVector = new Vector<Object>();
        for (int i = 0; i < iVectorSize; ++i) {
            Object o = valueList.get(i);
            if (o == null || cleanedVector.indexOf(o) > -1 || "".equals(o.toString())) continue;
            cleanedVector.add(o);
        }
        valueList = cleanedVector;
        if (valueList.size() == 0) {
            valueList.add("");
        }
        return valueList;
    }

    public void mergeRoles(List valueList, List sourceList, ItemCollection documentContext) throws PluginException {
        if (sourceList != null && sourceList.size() > 0) {
            for (Object o : sourceList) {
                if (valueList.indexOf(o) != -1) continue;
                if (o instanceof String) {
                    List<String> adaptedRoles = this.workflowService.adaptTextList((String)o, documentContext);
                    valueList.addAll(adaptedRoles);
                    continue;
                }
                valueList.add(o);
            }
        }
    }
}

