/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.ObserverException;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.annotation.RegistryScope;
import org.imixs.workflow.engine.DocumentEvent;
import org.imixs.workflow.engine.ProcessingEvent;
import org.imixs.workflow.exceptions.AccessDeniedException;

@ApplicationScoped
public class MetricService {
    public static final String METRIC_DOCUMENTS = "documents";
    public static final String METRIC_WORKITEMS = "workitems";
    public static final String METRIC_TRANSACTIONS = "transactions";
    @Inject
    @ConfigProperty(name="metrics.enabled", defaultValue="false")
    private boolean metricsEnabled;
    @Inject
    @ConfigProperty(name="metrics.anonymised", defaultValue="true")
    private boolean metricsAnonymised;
    @Inject
    @RegistryScope(scope="application")
    MetricRegistry metricRegistry;
    boolean mpMetricNoSupport = false;
    private static final Logger logger = Logger.getLogger(MetricService.class.getName());

    public void onProcessingEvent(@Observes ProcessingEvent processingEvent) throws AccessDeniedException {
        if (!this.metricsEnabled) {
            return;
        }
        if (processingEvent == null) {
            return;
        }
        if (this.mpMetricNoSupport) {
            return;
        }
        try {
            Counter counter = this.buildWorkitemMetric(processingEvent);
            counter.inc();
        }
        catch (ObserverException | IncompatibleClassChangeError oe) {
            this.mpMetricNoSupport = true;
            logger.warning("...Microprofile Metrics not supported!");
        }
    }

    public void onDocumentEvent(@Observes DocumentEvent documentEvent) throws AccessDeniedException {
        if (!this.metricsEnabled) {
            return;
        }
        if (documentEvent == null) {
            return;
        }
        if (this.mpMetricNoSupport) {
            return;
        }
        try {
            Counter counter = this.buildDocumentMetric(documentEvent);
            counter.inc();
        }
        catch (ObserverException | IncompatibleClassChangeError oe) {
            this.mpMetricNoSupport = true;
            logger.warning("...Microprofile Metrics not supported!");
            oe.printStackTrace();
        }
    }

    private Counter buildDocumentMetric(DocumentEvent event) {
        Metadata metadata = Metadata.builder().withName(METRIC_DOCUMENTS).withDescription("Imixs-Workflow count documents").build();
        String method = null;
        if (1 == event.getEventType()) {
            method = "save";
        }
        if (2 == event.getEventType()) {
            method = "load";
        }
        if (3 == event.getEventType()) {
            method = "delete";
        }
        Tag[] tags = new Tag[]{new Tag("method", method)};
        Counter counter = this.metricRegistry.counter(metadata, tags);
        return counter;
    }

    private Counter buildWorkitemMetric(ProcessingEvent event) {
        if (event.getEventType() == 1) {
            Metadata metadata = Metadata.builder().withName(METRIC_TRANSACTIONS).withDescription("Imixs-Workflow transactions").build();
            Counter counter = this.metricRegistry.counter(metadata);
            return counter;
        }
        ArrayList<Tag> tags = new ArrayList<Tag>();
        tags.add(new Tag("type", event.getDocument().getType()));
        tags.add(new Tag("modelversion", event.getDocument().getModelVersion()));
        tags.add(new Tag("task", "" + event.getDocument().getTaskID()));
        tags.add(new Tag("workflowgroup", event.getDocument().getItemValueString("$workflowgroup")));
        tags.add(new Tag("workflowstatus", event.getDocument().getItemValueString("$workflowstatus")));
        if (!this.metricsAnonymised) {
            String user = event.getDocument().getItemValueString("$editor");
            tags.add(new Tag("user", user));
        }
        tags.add(new Tag("event", "" + event.getDocument().getItemValueInteger("$lastevent")));
        Metadata metadata = Metadata.builder().withName(METRIC_WORKITEMS).withDescription("Imixs-Workflow count processed workitems").build();
        Tag[] tagArr = tags.toArray(new Tag[tags.size()]);
        Counter counter = this.metricRegistry.counter(metadata, tagArr);
        return counter;
    }
}

