/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine;

import jakarta.annotation.Resource;
import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ejb.SessionContext;
import jakarta.ejb.Stateless;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.ModelManager;
import org.imixs.workflow.Plugin;
import org.imixs.workflow.WorkflowContext;
import org.imixs.workflow.WorkflowKernel;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.engine.ProcessingEvent;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
public class SimulationService
implements WorkflowContext {
    private static final Logger logger = Logger.getLogger(SimulationService.class.getName());
    @Resource
    private SessionContext ctx;
    @Inject
    protected Event<ProcessingEvent> events;
    @Inject
    @Any
    private Instance<Plugin> plugins;
    @Inject
    private ModelService modelService;

    public ModelService getModelService() {
        return this.modelService;
    }

    public void setModelService(ModelService modelService) {
        this.modelService = modelService;
    }

    public SessionContext getCtx() {
        return this.ctx;
    }

    public void setCtx(SessionContext ctx) {
        this.ctx = ctx;
    }

    public ItemCollection processWorkItem(ItemCollection _workitem, List<String> vPlugins) throws AccessDeniedException, ProcessingErrorException, PluginException, ModelException {
        ItemCollection workitem = _workitem;
        long l = System.currentTimeMillis();
        if (workitem == null) {
            throw new ProcessingErrorException(SimulationService.class.getSimpleName(), "INVALID_WORKITEM", "WorkflowService: error - workitem is null");
        }
        if (this.events != null) {
            this.events.fire((Object)new ProcessingEvent(workitem, 1));
        } else {
            logger.warning("CDI Support is missing - ProcessingEvent will not be fired");
        }
        WorkflowKernel workflowkernel = new WorkflowKernel((WorkflowContext)this);
        if (vPlugins != null && vPlugins.size() > 0) {
            for (int i = 0; i < vPlugins.size(); ++i) {
                String aPluginClassName = vPlugins.get(i);
                Plugin aPlugin = this.findPluginByName(aPluginClassName);
                if (aPlugin != null) {
                    logger.log(Level.FINE, "register CDI plugin class: {0}...", aPluginClassName);
                    workflowkernel.registerPlugin(aPlugin);
                    continue;
                }
                workflowkernel.registerPlugin(aPluginClassName);
            }
        }
        try {
            workitem = workflowkernel.process(workitem);
        }
        catch (PluginException pe) {
            logger.log(Level.SEVERE, "processing workitem ''{0} failed, rollback transaction...", workitem.getItemValueString("$uniqueid"));
            throw pe;
        }
        logger.log(Level.FINE, "workitem ''{0}'' simulated in {1}ms", new Object[]{workitem.getItemValueString("$uniqueid"), System.currentTimeMillis() - l});
        if (this.events != null) {
            this.events.fire((Object)new ProcessingEvent(workitem, 2));
        }
        List splitWorkitems = workflowkernel.getSplitWorkitems();
        for (ItemCollection splitWorkitemm : splitWorkitems) {
            if (this.events == null) continue;
            this.events.fire((Object)new ProcessingEvent(splitWorkitemm, 2));
        }
        return workitem;
    }

    public ModelManager getModelManager() {
        return this.modelService;
    }

    public SessionContext getSessionContext() {
        return this.ctx;
    }

    private Plugin findPluginByName(String pluginClassName) {
        if (pluginClassName == null || pluginClassName.isEmpty()) {
            return null;
        }
        if (this.plugins == null || !this.plugins.iterator().hasNext()) {
            logger.fine("[SimulationService] no CDI plugins injected");
            return null;
        }
        for (Plugin plugin : this.plugins) {
            if (!plugin.getClass().getName().equals(pluginClassName)) continue;
            logger.log(Level.FINE, "[SimulationService] CDI plugin ''{0}'' successful injected", pluginClassName);
            return plugin;
        }
        return null;
    }
}

