/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.adminp;

import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.RunAs;
import jakarta.ejb.LocalBean;
import jakarta.ejb.Stateless;
import jakarta.ejb.TransactionAttribute;
import jakarta.ejb.TransactionAttributeType;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.adminp.AdminPException;
import org.imixs.workflow.engine.adminp.JobHandler;
import org.imixs.workflow.engine.index.UpdateService;
import org.imixs.workflow.engine.jpa.Document;
import org.imixs.workflow.exceptions.InvalidAccessException;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RunAs(value="org.imixs.ACCESSLEVEL.MANAGERACCESS")
@Stateless
@LocalBean
public class JobHandlerRebuildIndex
implements JobHandler {
    private static final int BLOCK_SIZE = 1000;
    @Inject
    @ConfigProperty(name="lucene.rebuild.time_out", defaultValue="60")
    int time_out;
    private static final int READ_AHEAD = 32;
    public static final String ITEM_SYNCPOINT = "syncpoint";
    public static final String ITEM_SYNCDATE = "syncdate";
    public static final String SNAPSHOT_TYPE_PRAFIX = "snapshot-";
    @PersistenceContext(unitName="org.imixs.workflow.jpa")
    private EntityManager manager;
    @Inject
    UpdateService updateService;
    private static final Logger logger = Logger.getLogger(JobHandlerRebuildIndex.class.getName());

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public ItemCollection run(ItemCollection adminp) throws AdminPException {
        long lProfiler = System.currentTimeMillis();
        long syncPoint = adminp.getItemValueLong("_syncpoint");
        int totalCount = adminp.getItemValueInteger("numUpdates");
        int blockCount = 0;
        int jobTimeOut = adminp.getItemValueInteger("numinterval");
        if (jobTimeOut > 0) {
            if (jobTimeOut <= 5) {
                logger.log(Level.WARNING, "fix deprecated interval of {0} - set new job interval to {1}sec", new Object[]{jobTimeOut, this.time_out});
                jobTimeOut = this.time_out;
            }
            this.time_out = jobTimeOut;
        }
        adminp.setItemValue("numinterval", (Object)this.time_out);
        logger.log(Level.INFO, "...Job JOB_REBUILD_INDEX ({0}) - lucene.rebuild.time_out={1}", new Object[]{adminp.getUniqueID(), this.time_out});
        try {
            block11: {
                long time;
                do {
                    ArrayList<ItemCollection> resultList = new ArrayList<ItemCollection>();
                    List<Document> documents = this.findNextDocumentsBySyncPoint(syncPoint);
                    if (documents == null || documents.size() <= 0) break block11;
                    for (Document doc : documents) {
                        syncPoint = doc.getCreated().getTimeInMillis();
                        try {
                            resultList.add(new ItemCollection(doc.getData()));
                        }
                        catch (InvalidAccessException e) {
                            logger.log(Level.WARNING, "...unable to index document ''{0}'' {1}", new Object[]{doc.getId(), e.getMessage()});
                        }
                        this.manager.detach((Object)doc);
                    }
                    this.updateService.updateIndex(resultList);
                    this.manager.flush();
                    totalCount += resultList.size();
                    if ((blockCount += resultList.size()) >= 1000) {
                        time = (System.currentTimeMillis() - lProfiler) / 1000L;
                        if (time == 0L) {
                            time = 1L;
                        }
                        logger.log(Level.INFO, "...Job JOB_REBUILD_INDEX ({0}) - ...{1} documents indexed in {2} sec. ... ", new Object[]{adminp.getUniqueID(), totalCount, time});
                        blockCount = 0;
                    }
                    if ((time = (System.currentTimeMillis() - lProfiler) / 1000L) != 0L) continue;
                    time = 1L;
                } while (time <= (long)this.time_out);
                logger.log(Level.INFO, "...Job JOB_REBUILD_INDEX ({0}) - suspended: {1} documents indexed in {2} sec. ", new Object[]{adminp.getUniqueID(), totalCount, time});
                adminp.replaceItemValue("_syncpoint", (Object)syncPoint);
                adminp.replaceItemValue("iscompleted", (Object)false);
                adminp.replaceItemValue("numUpdates", (Object)totalCount);
                adminp.replaceItemValue("numProcessed", (Object)totalCount);
                adminp.replaceItemValue("numLastCount", (Object)0);
                return adminp;
            }
            this.manager.flush();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "...Job JOB_REBUILD_INDEX ({0}) - failed - {1} last syncpoint  {2} - {3}  documents reindexed....", new Object[]{adminp.getUniqueID(), e.getMessage(), syncPoint, totalCount});
            e.printStackTrace();
            adminp.replaceItemValue("iscompleted", (Object)false);
            Date syncDate = new Date(syncPoint);
            adminp.replaceItemValue("error", (Object)e.getMessage());
            adminp.replaceItemValue(ITEM_SYNCPOINT, (Object)syncPoint);
            adminp.replaceItemValue(ITEM_SYNCDATE, (Object)syncDate);
            adminp.replaceItemValue("numUpdates", (Object)totalCount);
            adminp.replaceItemValue("numProcessed", (Object)totalCount);
            adminp.replaceItemValue("numLastCount", (Object)0);
            return adminp;
        }
        long time = (System.currentTimeMillis() - lProfiler) / 1000L;
        if (time == 0L) {
            time = 1L;
        }
        logger.log(Level.INFO, "...Job JOB_REBUILD_INDEX ({0}) - Finished: {1} documents indexed in {2} sec. ", new Object[]{adminp.getUniqueID(), totalCount, time});
        adminp.replaceItemValue("iscompleted", (Object)true);
        adminp.replaceItemValue("numUpdates", (Object)totalCount);
        adminp.replaceItemValue("numProcessed", (Object)totalCount);
        adminp.replaceItemValue("numLastCount", (Object)0);
        return adminp;
    }

    private List<Document> findNextDocumentsBySyncPoint(long lSyncpoint) {
        Date syncpoint = new Date(lSyncpoint);
        SimpleDateFormat isoFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        Object query = "SELECT document FROM Document AS document ";
        query = (String)query + " WHERE document.created > '" + isoFormat.format(syncpoint) + "'";
        query = (String)query + " AND NOT document.type LIKE 'snapshot-%' ";
        query = (String)query + " AND NOT document.type LIKE 'workitemlob%' ";
        query = (String)query + " AND document.type != 'event' ";
        query = (String)query + " ORDER BY document.created ASC";
        Query q = this.manager.createQuery((String)query);
        q.setFirstResult(0);
        q.setMaxResults(32);
        List documentList = q.getResultList();
        if (documentList != null && documentList.size() > 0) {
            Document lastDocument = null;
            Document nextToLastDocument = null;
            if (documentList.size() == 32) {
                lastDocument = (Document)documentList.get(31);
                nextToLastDocument = (Document)documentList.get(30);
                if (lastDocument != null && nextToLastDocument != null && lastDocument.getCreated().equals(nextToLastDocument.getCreated())) {
                    logger.finest("......there are more than one document with the same creation timestamp!");
                    syncpoint = new Date(lastDocument.getCreated().getTimeInMillis());
                    query = "SELECT document FROM Document AS document ";
                    query = (String)query + " WHERE document.created = '" + isoFormat.format(syncpoint) + "'";
                    query = (String)query + " AND NOT document.type LIKE 'snapshot-%' ";
                    query = (String)query + " AND NOT document.type LIKE 'workitemlob%' ";
                    query = (String)query + " AND document.type != 'event' ";
                    query = (String)query + " ORDER BY document.created ASC";
                    q = this.manager.createQuery((String)query);
                    q.setFirstResult(0);
                    q.setMaxResults(32);
                    documentList.addAll(q.getResultList());
                    return documentList;
                }
                documentList.remove(lastDocument);
                this.manager.detach((Object)lastDocument);
                return documentList;
            }
            return documentList;
        }
        return null;
    }
}

