/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.adminp;

import jakarta.annotation.Resource;
import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.RunAs;
import jakarta.ejb.LocalBean;
import jakarta.ejb.SessionContext;
import jakarta.ejb.Stateless;
import jakarta.ejb.TransactionAttribute;
import jakarta.ejb.TransactionAttributeType;
import jakarta.inject.Inject;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.adminp.AdminPException;
import org.imixs.workflow.engine.adminp.JobHandler;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RunAs(value="org.imixs.ACCESSLEVEL.MANAGERACCESS")
@Stateless
@LocalBean
public class JobHandlerUpgradeWorkitems
implements JobHandler {
    private static final int DEFAULT_BLOCK_SIZE = 100;
    @Resource
    SessionContext ctx;
    @Inject
    DocumentService documentService;
    private static Logger logger = Logger.getLogger(JobHandlerUpgradeWorkitems.class.getName());

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public ItemCollection run(ItemCollection adminp) throws AdminPException {
        long lProfiler = System.currentTimeMillis();
        int iIndex = adminp.getItemValueInteger("numIndex");
        int iBlockSize = adminp.getItemValueInteger("numBlockSize");
        if (iBlockSize <= 0) {
            iBlockSize = 100;
            adminp.replaceItemValue("numBlockSize", (Object)iBlockSize);
        }
        int iUpdates = adminp.getItemValueInteger("numUpdates");
        int iProcessed = adminp.getItemValueInteger("numProcessed");
        String query = this.buildQuery(adminp);
        logger.log(Level.FINEST, "......JQPL query: {0}", query);
        adminp.replaceItemValue("txtQuery", (Object)query);
        logger.info("... selecting workitems...");
        List<ItemCollection> workitemList = this.documentService.getDocumentsByQuery(query, iIndex, iBlockSize);
        int colSize = workitemList.size();
        logger.log(Level.INFO, "Job UPGRADE ({0}) - verifeing {1} workitems...", new Object[]{adminp.getUniqueID(), colSize});
        int iCount = 0;
        for (ItemCollection workitem : workitemList) {
            if (!workitem.hasItem("$modelversion") || !this.upgradeWorkitem(workitem)) continue;
            logger.log(Level.INFO, "...upgrade ''{0}'' ...", workitem.getUniqueID());
            this.documentService.saveByNewTransaction(workitem);
            ++iCount;
        }
        adminp.replaceItemValue("numUpdates", (Object)(iUpdates += iCount));
        adminp.replaceItemValue("numProcessed", (Object)(iProcessed += colSize));
        adminp.replaceItemValue("numIndex", (Object)(iIndex += colSize));
        long time = (System.currentTimeMillis() - lProfiler) / 1000L;
        if (time == 0L) {
            time = 1L;
        }
        logger.log(Level.INFO, "Job UPGRADE ({0}) - {1} documents processed, {2} updates in {3} sec.  (in total: {4} processed, {5} updates)", new Object[]{adminp.getUniqueID(), colSize, iCount, time, iProcessed, iUpdates});
        if (colSize < iBlockSize) {
            adminp.replaceItemValue("iscompleted", (Object)true);
        }
        return adminp;
    }

    public boolean upgradeWorkitem(ItemCollection workitem) {
        boolean bUpgrade = false;
        if (workitem.getItemValueBoolean("$immutable")) {
            return false;
        }
        if (!workitem.hasItem("$workflowGroup")) {
            workitem.replaceItemValue("$workflowGroup", (Object)workitem.getItemValue("txtworkflowgroup"));
            bUpgrade = true;
        }
        if (!workitem.hasItem("$workflowStatus")) {
            workitem.replaceItemValue("$workflowStatus", (Object)workitem.getItemValue("txtworkflowstatus"));
            bUpgrade = true;
        }
        if (!workitem.hasItem("$lastEvent")) {
            workitem.replaceItemValue("$lastEvent", (Object)workitem.getItemValue("numlastactivityid"));
            bUpgrade = true;
        }
        if (!workitem.hasItem("$lastEventDate")) {
            workitem.replaceItemValue("$lastEventDate", (Object)workitem.getItemValue("timworkflowlastaccess"));
            bUpgrade = true;
        }
        if (!workitem.hasItem("$creator")) {
            workitem.replaceItemValue("$creator", (Object)workitem.getItemValue("namcreator"));
            bUpgrade = true;
        }
        if (!workitem.hasItem("$taskid")) {
            workitem.replaceItemValue("$taskid", (Object)workitem.getItemValue("$processid"));
            bUpgrade = true;
        }
        if (!workitem.hasItem("$owner")) {
            workitem.replaceItemValue("$owner", (Object)workitem.getItemValue("namowner"));
            bUpgrade = true;
        }
        if (!workitem.hasItem("process.name")) {
            workitem.replaceItemValue("process.name", (Object)workitem.getItemValue("txtprocessname"));
            workitem.replaceItemValue("process.ref", (Object)workitem.getItemValue("txtprocessRef"));
            workitem.replaceItemValue("space.name", (Object)workitem.getItemValue("txtspacename"));
            workitem.replaceItemValue("space.ref", (Object)workitem.getItemValue("txtspaceRef"));
            workitem.replaceItemValue("space.assist", (Object)workitem.getItemValue("namspaceassist"));
            workitem.replaceItemValue("space.team", (Object)workitem.getItemValue("namspaceTeam"));
            workitem.replaceItemValue("space.manager", (Object)workitem.getItemValue("namspaceManager"));
            workitem.replaceItemValue("process.assist", (Object)workitem.getItemValue("namprocessassist"));
            workitem.replaceItemValue("process.team", (Object)workitem.getItemValue("namprocessTeam"));
            workitem.replaceItemValue("process.manager", (Object)workitem.getItemValue("namprocessManager"));
            bUpgrade = true;
        }
        return bUpgrade;
    }

    private String buildQuery(ItemCollection adminp) {
        Date datFilterFrom = adminp.getItemValueDate("datfrom");
        Date datFilterTo = adminp.getItemValueDate("datto");
        String typeFilter = adminp.getItemValueString("typelist");
        SimpleDateFormat isoFormat = new SimpleDateFormat("yyyy-MM-dd");
        boolean bAddAnd = false;
        Object query = "SELECT document FROM Document AS document ";
        query = (String)query + "WHERE document.type NOT IN ('event') ";
        query = (String)query + "AND document.type NOT LIKE 'snapshot%' ";
        query = (String)query + "AND document.type NOT LIKE 'workitemlob%' ";
        if (typeFilter != null && !typeFilter.isEmpty()) {
            List<String> typeList = Arrays.asList(typeFilter.split("\\s*,\\s*"));
            Object sType = "";
            for (String aValue : typeList) {
                sType = (String)sType + "'" + aValue.trim() + "',";
            }
            sType = ((String)sType).substring(0, ((String)sType).length() - 1);
            query = (String)query + " AND document.type IN(" + (String)sType + ")";
            bAddAnd = true;
        } else {
            query = (String)query + " AND document.type IN('workitem')";
            bAddAnd = true;
        }
        if (datFilterFrom != null) {
            if (bAddAnd) {
                query = (String)query + " AND ";
            }
            query = (String)query + " document.created>='" + isoFormat.format(datFilterFrom) + "' ";
            bAddAnd = true;
        }
        if (datFilterTo != null) {
            if (bAddAnd) {
                query = (String)query + " AND ";
            }
            query = (String)query + " document.created<='" + isoFormat.format(datFilterTo) + "' ";
            bAddAnd = true;
        }
        query = (String)query + " ORDER BY document.created";
        return query;
    }
}

