/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.jpa;

import jakarta.persistence.Basic;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.Lob;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Version;
import java.io.Serializable;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.imixs.workflow.WorkflowKernel;

@Entity
public class EventLog
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String topic;
    private String ref;
    private Integer version;
    private Calendar created;
    private Map<String, List<Object>> data;
    private Calendar timeout;

    public EventLog() {
    }

    public EventLog(String topic, String ref, Map<String, List<Object>> data) {
        Calendar cal;
        this.id = WorkflowKernel.generateUniqueID();
        this.created = cal = Calendar.getInstance();
        this.topic = topic;
        this.ref = ref;
        this.data = data;
        this.timeout = cal;
    }

    @Id
    public String getId() {
        return this.id;
    }

    protected void setId(String aID) {
        this.id = aID;
    }

    @Version
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    public Calendar getCreated() {
        return this.created;
    }

    public void setCreated(Calendar created) {
        this.created = created;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    public Calendar getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Calendar timeout) {
        this.timeout = timeout;
    }

    @Lob
    @Basic(fetch=FetchType.EAGER)
    public Map<String, List<Object>> getData() {
        return this.data;
    }

    public void setData(Map<String, List<Object>> itemCol) {
        this.data = itemCol;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.ref == null ? 0 : this.ref.hashCode());
        result = 31 * result + (this.topic == null ? 0 : this.topic.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventLog other = (EventLog)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.ref == null ? other.ref != null : !this.ref.equals(other.ref)) {
            return false;
        }
        return !(this.topic == null ? other.topic != null : !this.topic.equals(other.topic));
    }

    public String toString() {
        return this.getTopic() + ":" + this.getId();
    }
}

