/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.plugins;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;

public class OwnerPlugin
extends AbstractPlugin {
    public static final String OWNER = "$owner";
    private ItemCollection documentContext;
    private ItemCollection documentActivity;
    private ItemCollection documentNextProcessEntity;
    private static final Logger logger = Logger.getLogger(OwnerPlugin.class.getName());

    public ItemCollection run(ItemCollection adocumentContext, ItemCollection adocumentActivity) throws PluginException {
        this.documentContext = adocumentContext;
        this.documentActivity = adocumentActivity;
        try {
            this.documentNextProcessEntity = this.getWorkflowService().evalNextTask(adocumentContext);
        }
        catch (ModelException e) {
            throw new PluginException(OwnerPlugin.class.getSimpleName(), e.getErrorCode(), e.getMessage());
        }
        if (!(this.documentActivity.getItemValueBoolean("keyupdateacl") || this.documentNextProcessEntity != null && this.documentNextProcessEntity.getItemValueBoolean("keyupdateacl"))) {
            return this.documentContext;
        }
        if (this.documentActivity.getItemValueBoolean("keyupdateacl")) {
            this.updateOwnerByItemCollection(this.documentActivity);
        } else {
            this.updateOwnerByItemCollection(this.documentNextProcessEntity);
        }
        return this.documentContext;
    }

    private void updateOwnerByItemCollection(ItemCollection modelEntity) throws PluginException {
        if (modelEntity == null || !modelEntity.getItemValueBoolean("keyupdateacl")) {
            return;
        }
        List<Object> newOwnerList = new ArrayList<Object>();
        this.mergeRoles(newOwnerList, modelEntity.getItemValue("namOwnershipNames"), this.documentContext);
        this.mergeFieldList(this.documentContext, newOwnerList, modelEntity.getItemValue("keyOwnershipFields"));
        newOwnerList = this.uniqueList(newOwnerList);
        this.documentContext.replaceItemValue(OWNER, newOwnerList);
        if (logger.isLoggable(Level.FINE) && newOwnerList.size() > 0) {
            logger.finest("......Owners:");
            for (int j = 0; j < newOwnerList.size(); ++j) {
                logger.log(Level.FINEST, "               ''{0}''", (String)newOwnerList.get(j));
            }
        }
        this.documentContext.replaceItemValue("namOwner", newOwnerList);
    }

    public void mergeRoles(List valueList, List sourceList, ItemCollection documentContext) throws PluginException {
        if (sourceList != null && sourceList.size() > 0) {
            for (Object o : sourceList) {
                if (valueList.indexOf(o) != -1) continue;
                if (o instanceof String) {
                    List<String> adaptedRoles = this.getWorkflowService().adaptTextList((String)o, documentContext);
                    valueList.addAll(adaptedRoles);
                    continue;
                }
                valueList.add(o);
            }
        }
    }
}

