/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.plugins;

import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.exceptions.PluginException;

public class ResultPlugin
extends AbstractPlugin {
    public static List<String> SPPORTED_KERNEL_ITEMS = Arrays.asList("$file", "$snapshot.history");
    private static final Logger logger = Logger.getLogger(ResultPlugin.class.getName());

    public ItemCollection run(ItemCollection documentContext, ItemCollection event) throws PluginException {
        ItemCollection evalItemCollection = this.getWorkflowService().evalWorkflowResult(event, "item", documentContext, true);
        if (evalItemCollection != null) {
            List itemNameList = evalItemCollection.getItemNames();
            for (String itemName : itemNameList) {
                if (this.isValidItemName(itemName)) continue;
                logger.log(Level.WARNING, "<item> tag contains unsupported item name ''{0}'' - verify event result definition!", itemName);
                evalItemCollection.removeItem(itemName);
            }
            documentContext.replaceAllItems(evalItemCollection.getAllItems());
        }
        return documentContext;
    }

    public boolean isValidItemName(String itemName) {
        return !itemName.startsWith("$") || SPPORTED_KERNEL_ITEMS.contains(itemName.toLowerCase());
    }
}

