/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine;

import jakarta.annotation.Priority;
import jakarta.ejb.Stateless;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.TextEvent;
import org.imixs.workflow.engine.TextItemValueAdapter;
import org.imixs.workflow.util.XMLParser;

@Stateless
public class TextForEachAdapter {
    private static final Logger logger = Logger.getLogger(TextForEachAdapter.class.getName());
    @Inject
    protected Event<TextEvent> textEvents;

    public void onEvent(@Observes @Priority(value=1990) TextEvent event) {
        Object text = event.getText();
        Object textResult = "";
        boolean debug = logger.isLoggable(Level.FINE);
        List tagList = XMLParser.findNoEmptyTags((String)text, (String)"for-each");
        if (debug) {
            logger.log(Level.FINEST, "......{0} tags found", tagList.size());
        }
        for (String tag : tagList) {
            String itemName = XMLParser.findAttribute((String)tag, (String)"item");
            String innervalue = XMLParser.findTagValue((String)tag, (String)"for-each");
            List values = event.getDocument().getItemValue(itemName);
            for (Object _value : values) {
                ItemCollection _tempDoc;
                block7: {
                    _tempDoc = null;
                    if (_value instanceof Map) {
                        try {
                            _tempDoc = new ItemCollection((Map)_value);
                            break block7;
                        }
                        catch (ClassCastException e) {
                            logger.warning("unable to cast embedded map to ItemCollection!");
                            continue;
                        }
                    }
                    _tempDoc = new ItemCollection(event.getDocument());
                    _tempDoc.setItemValue(itemName, _value);
                }
                TextEvent _event = new TextEvent(new String(innervalue), _tempDoc);
                if (this.textEvents != null) {
                    this.textEvents.fire((Object)_event);
                    textResult = (String)textResult + _event.getText();
                    continue;
                }
                logger.warning("CDI Support is missing - TextEvent wil not be fired");
                TextItemValueAdapter tiva = new TextItemValueAdapter();
                tiva.onEvent(_event);
                textResult = (String)textResult + _event.getText();
            }
            int iStartPos = ((String)text).indexOf(tag);
            int iEndPos = ((String)text).indexOf(tag) + tag.length();
            text = ((String)text).substring(0, iStartPos) + (String)textResult + ((String)text).substring(iEndPos);
        }
        event.setText((String)text);
    }
}

