/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.plugins;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.exceptions.PluginException;

public class ApproverPlugin
extends AbstractPlugin {
    private static final Logger logger = Logger.getLogger(ApproverPlugin.class.getName());
    public static String APPROVEDBY = "$approvedby";
    public static String APPROVERS = "$approvers";
    private static String EVAL_APPROVEDBY = "approvedby";

    public ItemCollection run(ItemCollection workitem, ItemCollection event) throws PluginException {
        boolean refresh = false;
        boolean reset = false;
        ItemCollection evalItemCollection = this.getWorkflowService().evalWorkflowResult(event, "item", workitem);
        if (evalItemCollection != null && evalItemCollection.hasItem(EVAL_APPROVEDBY)) {
            boolean debug = logger.isLoggable(Level.FINE);
            refresh = true;
            if ("false".equals(evalItemCollection.getItemValueString(EVAL_APPROVEDBY + ".refresh"))) {
                refresh = false;
            }
            if (debug) {
                logger.log(Level.FINE, "refresh={0}", refresh);
            }
            reset = false;
            if ("true".equals(evalItemCollection.getItemValueString(EVAL_APPROVEDBY + ".reset"))) {
                reset = true;
            }
            if (debug) {
                logger.log(Level.FINE, "reset={0}", reset);
            }
            List groups = evalItemCollection.getItemValue(EVAL_APPROVEDBY);
            for (String aGroup : groups) {
                List nameList = workitem.getItemValue(aGroup);
                nameList.removeIf(item -> item == null || "".equals(item));
                List newAppoverList = nameList.stream().distinct().collect(Collectors.toList());
                if (!workitem.hasItem(aGroup + APPROVERS) || reset) {
                    if (debug) {
                        logger.log(Level.FINE, "creating new approver list: {0}={1}", new Object[]{aGroup, newAppoverList});
                    }
                    workitem.replaceItemValue(aGroup + APPROVERS, newAppoverList);
                    workitem.removeItem(aGroup + APPROVEDBY);
                    continue;
                }
                if (refresh) {
                    this.refreshApprovers(workitem, aGroup);
                }
                String currentAppover = this.getWorkflowService().getUserName();
                List listApprovedBy = workitem.getItemValue(aGroup + APPROVEDBY);
                List listApprovers = workitem.getItemValue(aGroup + APPROVERS);
                if (debug) {
                    logger.log(Level.FINE, "approved by:  {0}", currentAppover);
                }
                if (!listApprovers.contains(currentAppover) || listApprovedBy.contains(currentAppover)) continue;
                listApprovers.remove(currentAppover);
                listApprovedBy.add(currentAppover);
                listApprovers.removeIf(item -> item == null || "".equals(item));
                listApprovedBy.removeIf(item -> item == null || "".equals(item));
                workitem.replaceItemValue(aGroup + APPROVERS, (Object)listApprovers);
                workitem.replaceItemValue(aGroup + APPROVEDBY, (Object)listApprovedBy);
                if (!debug) continue;
                logger.log(Level.FINE, "new list of approvedby: {0}={1}", new Object[]{aGroup, listApprovedBy});
            }
        }
        return workitem;
    }

    void refreshApprovers(ItemCollection workitem, String sourceItem) {
        boolean debug = logger.isLoggable(Level.FINE);
        List nameList = workitem.getItemValue(sourceItem);
        nameList.removeIf(item -> item == null || "".equals(item));
        List newAppoverList = nameList.stream().distinct().collect(Collectors.toList());
        List listApprovedBy = workitem.getItemValue(sourceItem + APPROVEDBY);
        List listApprovers = workitem.getItemValue(sourceItem + APPROVERS);
        boolean update = false;
        for (String approver : newAppoverList) {
            if (listApprovedBy.contains(approver) || listApprovers.contains(approver)) continue;
            if (debug) {
                logger.log(Level.FINE, "adding new approver to list ''{0}{1}''", new Object[]{sourceItem, APPROVERS});
            }
            listApprovers.add(approver);
            listApprovers.removeIf(item -> item == null || "".equals(item));
            update = true;
        }
        if (update) {
            if (debug) {
                logger.log(Level.FINE, "updating approver list ''{0}{1}''", new Object[]{sourceItem, APPROVERS});
            }
            workitem.replaceItemValue(sourceItem + APPROVERS, (Object)listApprovers);
        }
    }
}

