/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.plugins;

import java.time.LocalDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.util.XMLParser;

public class IntervalPlugin
extends AbstractPlugin {
    public static final String EVAL_INTERVAL = "interval";
    public static final String INVALID_FORMAT = "INVALID_FORMAT";
    public boolean increase = false;
    private ItemCollection documentContext;
    private static final Logger logger = Logger.getLogger(IntervalPlugin.class.getName());

    public ItemCollection run(ItemCollection adocumentContext, ItemCollection event) throws PluginException {
        ItemCollection evalItemCollection;
        LocalDateTime result = null;
        this.documentContext = adocumentContext;
        Set fieldNames = this.documentContext.getAllItems().keySet();
        Optional<String> optional = fieldNames.stream().filter(x -> x.toLowerCase().startsWith("keyinterval")).findFirst();
        if (optional.isPresent()) {
            logger.warning("Note: keyinterval is no longer supported by the intervalPlugin. Use instead a cron configuration.");
        }
        if ((evalItemCollection = this.getWorkflowService().evalWorkflowResult(event, "item", adocumentContext, true)) != null && evalItemCollection.hasItem(EVAL_INTERVAL)) {
            String invervalDef = evalItemCollection.getItemValueString(EVAL_INTERVAL);
            if (invervalDef.trim().isEmpty()) {
                return adocumentContext;
            }
            ItemCollection processData = XMLParser.parseItemStructure((String)invervalDef);
            String cron = processData.getItemValueString("cron").trim().toLowerCase();
            String macro = processData.getItemValueString("macro").trim().toLowerCase();
            String ref = processData.getItemValueString("ref").trim().toLowerCase();
            if (!cron.isEmpty() && !macro.isEmpty()) {
                throw new PluginException(IntervalPlugin.class.getName(), INVALID_FORMAT, "invalid interval configuration: cron and macro can not be combined!");
            }
            LocalDateTime refDate = this.documentContext.getItemValueLocalDateTime(ref);
            if (!macro.isEmpty() && refDate == null) {
                throw new PluginException(IntervalPlugin.class.getName(), INVALID_FORMAT, "invalid interval configuration: ref item is missing for macro!");
            }
            logger.log(Level.INFO, "......cron={0}", cron);
            logger.log(Level.INFO, "......macro={0}", macro);
            logger.log(Level.INFO, "......ref={0}", ref);
            result = !cron.isEmpty() ? this.evalCron(cron) : this.evalMacro(macro, refDate);
            if (result != null) {
                this.documentContext.replaceItemValue(ref, (Object)result);
            }
        }
        return this.documentContext;
    }

    public LocalDateTime evalCron(String cron, LocalDateTime baseDateTime) throws PluginException {
        LocalDateTime result;
        block8: {
            result = null;
            String[] cronDef = cron.split(" ");
            if (cronDef.length != 5) {
                throw new PluginException(IntervalPlugin.class.getName(), INVALID_FORMAT, "invalid cron format: " + cron);
            }
            result = baseDateTime == null ? LocalDateTime.now().withSecond(0) : baseDateTime;
            this.increase = true;
            try {
                String minute = cronDef[0];
                result = this.adjustDateTimeByCronUnit(minute, result, ChronoUnit.MINUTES, ChronoField.MINUTE_OF_HOUR);
                String hour = cronDef[1];
                result = this.adjustDateTimeByCronUnit(hour, result, ChronoUnit.HOURS, ChronoField.HOUR_OF_DAY);
                String dayofmonth = cronDef[2];
                result = this.adjustDateTimeByCronUnit(dayofmonth, result, ChronoUnit.DAYS, ChronoField.DAY_OF_MONTH);
                String month = cronDef[3];
                result = this.adjustDateTimeByCronUnit(month, result, ChronoUnit.MONTHS, ChronoField.MONTH_OF_YEAR);
            }
            catch (NumberFormatException e) {
                throw new PluginException(IntervalPlugin.class.getName(), INVALID_FORMAT, "invalid cron format: " + cron + " Note: we do not yet support all kind of patterns.");
            }
            Object dayofweek = cronDef[4];
            if ("*".equals(dayofweek)) {
                if (this.increase) {
                    this.increase = false;
                    result = result.plusYears(1L);
                }
            } else {
                if (!((String)dayofweek).startsWith("[")) {
                    dayofweek = "[" + (String)dayofweek + "]";
                }
                int count = 0;
                do {
                    int dow = result.getDayOfWeek().getValue();
                    if (Pattern.compile((String)dayofweek).matcher("" + dow).find()) break block8;
                    result = result.plusDays(1L);
                } while (++count <= 7);
                throw new PluginException(IntervalPlugin.class.getName(), INVALID_FORMAT, "invalid cron format 'DayOfWeek' : " + cron);
            }
        }
        return result;
    }

    public LocalDateTime evalCron(String cron) throws PluginException {
        return this.evalCron(cron, null);
    }

    public LocalDateTime evalMacro(String macro, LocalDateTime ldt) throws PluginException {
        switch (macro) {
            case "@yearly": {
                ldt = ldt.plusYears(1L);
                break;
            }
            case "@monthly": {
                ldt = ldt.plusMonths(1L);
                break;
            }
            case "@weekly": {
                ldt = ldt.plusWeeks(1L);
                break;
            }
            case "@daily": {
                ldt = ldt.plusDays(1L);
                break;
            }
            case "@hourly": {
                ldt = ldt.plusHours(1L);
                break;
            }
            default: {
                return null;
            }
        }
        return ldt;
    }

    private LocalDateTime adjustDateTimeByCronUnit(String cronUnit, LocalDateTime baseDateTime, TemporalUnit tempUnit, TemporalField tempField) {
        if (cronUnit.equals("*")) {
            if (this.increase) {
                this.increase = false;
                baseDateTime = baseDateTime.plus(1L, tempUnit);
            }
        } else {
            int nowUnit = baseDateTime.get(tempField);
            if (cronUnit.contains(",")) {
                String[] units = cronUnit.split(",");
                logger.log(Level.INFO, " unit now = {0}", nowUnit);
                boolean found = false;
                for (String singleUnit : units) {
                    if (Integer.parseInt(singleUnit) < nowUnit) continue;
                    baseDateTime = baseDateTime.with(tempField, Integer.parseInt(singleUnit));
                    found = true;
                    this.increase = false;
                    break;
                }
                if (!found) {
                    baseDateTime = baseDateTime.with(tempField, Integer.parseInt(units[0]));
                    this.increase = true;
                }
            } else {
                baseDateTime = baseDateTime.with(tempField, Integer.parseInt(cronUnit));
                if (nowUnit < Integer.parseInt(cronUnit)) {
                    this.increase = false;
                }
            }
        }
        return baseDateTime;
    }
}

