/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine;

import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ejb.EJBException;
import jakarta.ejb.Stateless;
import jakarta.ejb.TransactionAttribute;
import jakarta.ejb.TransactionAttributeType;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import jakarta.persistence.OptimisticLockException;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.Model;
import org.imixs.workflow.engine.EventLogService;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.engine.ProcessingEvent;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.engine.jpa.EventLog;
import org.imixs.workflow.exceptions.InvalidAccessException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.WorkflowException;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
public class AsyncEventService {
    @Inject
    @ConfigProperty(name="asyncevent.processor.enabled", defaultValue="false")
    boolean enabled;
    private static final Logger logger = Logger.getLogger(AsyncEventService.class.getName());
    @Inject
    EventLogService eventLogService;
    @Inject
    private WorkflowService workflowService;
    @Inject
    private ModelService modelService;

    public void onProcess(@Observes ProcessingEvent processingEvent) throws ModelException {
        if (!this.enabled) {
            return;
        }
        boolean debug = logger.isLoggable(Level.FINE);
        if (2 == processingEvent.getEventType()) {
            int taskID = processingEvent.getDocument().getTaskID();
            Model model = this.modelService.getModelByWorkitem(processingEvent.getDocument());
            ItemCollection task = model.getTask(taskID);
            if (task != null) {
                int boundaryTarget = task.getItemValueInteger("boundaryEvent.targetEvent");
                int boundaryDuration = task.getItemValueInteger("boundaryEvent.timerEventDefinition.timeDuration");
                if (boundaryTarget > 0) {
                    if (debug) {
                        logger.log(Level.FINEST, "......create new async event - eventId={0}", boundaryTarget);
                    }
                    Calendar cal = Calendar.getInstance();
                    cal.add(14, boundaryDuration);
                    ItemCollection asyncEventData = new ItemCollection().event(boundaryTarget);
                    asyncEventData.setItemValue("timeDuration", (Object)boundaryDuration);
                    asyncEventData.setItemValue("$transactionid", (Object)processingEvent.getDocument().getItemValueString("$transactionid"));
                    this.eventLogService.createEvent("async.event", processingEvent.getDocument().getUniqueID(), asyncEventData, cal);
                }
            }
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void processEventLog() {
        long l = System.currentTimeMillis();
        boolean debug = logger.isLoggable(Level.FINE);
        List<EventLog> events = this.eventLogService.findEventsByTimeout(100, "async.event");
        if (debug) {
            logger.log(Level.FINEST, "......found {0} eventLog entries", events.size());
        }
        for (EventLog eventLogEntry : events) {
            try {
                ItemCollection workitem;
                if (!this.eventLogService.lock(eventLogEntry) || (workitem = this.workflowService.getWorkItem(eventLogEntry.getRef())) == null) continue;
                try {
                    ItemCollection syncEventData = new ItemCollection(eventLogEntry.getData());
                    if (workitem.getItemValueString("$transactionid").equals(syncEventData.getItemValueString("$transactionid"))) {
                        workitem.setEventID(syncEventData.getEventID());
                        workitem = this.workflowService.processWorkItemByNewTransaction(workitem);
                    } else {
                        logger.log(Level.INFO, "...AsyncEvent {0} for {1} is deprecated and will be removed. ({2} \u2260 {3}", new Object[]{syncEventData.getEventID(), workitem.getUniqueID(), workitem.getItemValueString("$transactionid"), syncEventData.getItemValueString("$transactionid")});
                    }
                    this.eventLogService.removeEvent(eventLogEntry.getId());
                }
                catch (EJBException | InvalidAccessException | WorkflowException e) {
                    logger.log(Level.SEVERE, "AsyncEvent {0} processing failed: {1}", new Object[]{workitem.getUniqueID(), e.getMessage()});
                    logger.log(Level.WARNING, "AsyncEvent {0} will be removed!", workitem.getUniqueID());
                    this.eventLogService.removeEvent(eventLogEntry.getId());
                }
            }
            catch (OptimisticLockException e) {
                logger.log(Level.INFO, "...unable to lock AsyncEvent: {0}", e.getMessage());
            }
        }
        if (debug) {
            logger.log(Level.FINE, "...{0} AsyncEvents processed in {1}ms", new Object[]{events.size(), System.currentTimeMillis() - l});
        }
    }
}

