/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine;

import jakarta.annotation.Resource;
import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ejb.ConcurrencyManagement;
import jakarta.ejb.LocalBean;
import jakarta.ejb.SessionContext;
import jakarta.ejb.Singleton;
import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.Model;
import org.imixs.workflow.ModelManager;
import org.imixs.workflow.bpmn.BPMNModel;
import org.imixs.workflow.bpmn.BPMNParser;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.InvalidAccessException;
import org.imixs.workflow.exceptions.ModelException;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Singleton
@LocalBean
@ConcurrencyManagement
public class ModelService
implements ModelManager {
    private ConcurrentHashMap<String, Model> modelStore = null;
    private static final Logger logger = Logger.getLogger(ModelService.class.getName());
    private Map<String, ItemCollection> modelEntityStore;
    @Inject
    private DocumentService documentService;
    @Resource
    private SessionContext ctx;

    void init() throws AccessDeniedException {
        boolean debug = logger.isLoggable(Level.FINE);
        this.modelEntityStore = new HashMap<String, ItemCollection>();
        if (debug) {
            logger.finest("......Initializing ModelService...");
        }
        List<ItemCollection> col = this.documentService.getDocumentsByType("model");
        for (ItemCollection modelEntity : col) {
            List files = modelEntity.getFileData();
            for (FileData file : files) {
                if (debug) {
                    logger.log(Level.FINEST, "......loading file:{0}", file.getName());
                }
                byte[] rawData = file.getContent();
                ByteArrayInputStream bpmnInputStream = new ByteArrayInputStream(rawData);
                try {
                    BPMNModel model = BPMNParser.parseModel((InputStream)bpmnInputStream, (String)"UTF-8");
                    ItemCollection definition = model.getDefinition();
                    if (definition == null) continue;
                    String modelVersion = definition.getModelVersion();
                    try {
                        if (this.getModel(modelVersion) == null) continue;
                        logger.log(Level.WARNING, "Model ''{0}'' is duplicated! Please update the model version!", modelVersion);
                    }
                    catch (ModelException e) {
                        this.addModel((Model)model);
                        this.modelEntityStore.put(modelVersion, modelEntity);
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Failed to load model ''{0}'' : {1}", new Object[]{file.getName(), e.getMessage()});
                }
            }
        }
    }

    public void addModel(Model model) throws ModelException {
        ItemCollection definition = model.getDefinition();
        if (definition == null) {
            throw new ModelException("INVALID_MODEL", "Invalid Model: Model Definition not provided! ");
        }
        String modelVersion = definition.getModelVersion();
        if (modelVersion.isEmpty()) {
            throw new ModelException("INVALID_MODEL", "Invalid Model: Model Version not provided! ");
        }
        logger.log(Level.INFO, "\u27f3 updated model version: ''{0}''", model.getVersion());
        this.getModelStore().put(modelVersion, model);
    }

    public void removeModel(String modelversion) {
        boolean debug = logger.isLoggable(Level.FINE);
        this.getModelStore().remove(modelversion);
        if (debug) {
            logger.log(Level.FINEST, "......removed BPMNModel ''{0}''...", modelversion);
        }
    }

    public Model getModel(String version) throws ModelException {
        List<String> modelList;
        Model model = this.getModelStore().get(version);
        if (model == null && version != null && !version.isEmpty() && (modelList = this.findVersionsByRegEx(version)) != null && modelList.size() > 0) {
            version = modelList.get(0);
            model = this.getModelStore().get(version);
        }
        if (model == null) {
            throw new ModelException("UNDEFINED_MODEL_VERSION", "Modelversion '" + version + "' not found!");
        }
        return model;
    }

    public Model getModelByWorkitem(ItemCollection workitem) throws ModelException {
        Model model;
        String workflowGroup;
        String modelVersion;
        block7: {
            boolean debug = logger.isLoggable(Level.FINE);
            modelVersion = workitem.getModelVersion();
            workflowGroup = workitem.getItemValueString("$workflowgroup");
            if (workflowGroup.isEmpty()) {
                workflowGroup = workitem.getItemValueString("txtworkflowgroup");
            }
            model = null;
            try {
                model = this.getModel(modelVersion);
            }
            catch (ModelException me) {
                String newVersion;
                model = null;
                List<String> versions = null;
                if (debug) {
                    logger.finest(me.getMessage());
                }
                if (modelVersion != null && !modelVersion.isEmpty() && !(versions = this.findVersionsByRegEx(modelVersion)).isEmpty()) {
                    newVersion = versions.get(0);
                    logger.log(Level.INFO, "...... match version ''{0}'' -> by regex ''{1}''", new Object[]{newVersion, modelVersion});
                    workitem.replaceItemValue("$modelversion", (Object)newVersion);
                    model = this.getModel(newVersion);
                }
                if (model != null || workflowGroup.isEmpty() || (versions = this.findVersionsByGroup(workflowGroup)).isEmpty()) break block7;
                newVersion = versions.get(0);
                if (!modelVersion.isEmpty()) {
                    logger.log(Level.WARNING, "Deprecated model version: ''{0}'' -> migrating to ''{1}'',  $workflowgroup: ''{2}'', $uniqueid: {3}", new Object[]{modelVersion, newVersion, workflowGroup, workitem.getUniqueID()});
                }
                workitem.replaceItemValue("$modelversion", (Object)newVersion);
                model = this.getModel(newVersion);
            }
        }
        if (model == null) {
            throw new ModelException("UNDEFINED_MODEL_VERSION", "No matching $modelversion found for '" + modelVersion + "', $workflowgroup: '" + workflowGroup + "', $uniqueid: " + workitem.getUniqueID());
        }
        return model;
    }

    public List<String> getVersions() {
        Set<String> set = this.getModelStore().keySet();
        ArrayList<String> result = new ArrayList<String>(set);
        result.sort(String::compareTo);
        return result;
    }

    public List<String> getLatestVersions() {
        ArrayList<String> result = new ArrayList<String>();
        List<String> groups = this.getGroups();
        for (String group : groups) {
            String version;
            List<String> versions = this.findVersionsByGroup(group);
            if (versions == null || versions.size() <= 0 || result.contains(version = versions.get(0))) continue;
            result.add(version);
        }
        Collections.sort(result);
        return result;
    }

    public List<String> getGroups() {
        ArrayList<String> result = new ArrayList<String>();
        Collection<Model> models = this.getModelStore().values();
        for (Model amodel : models) {
            for (String group : amodel.getGroups()) {
                if (result.contains(group)) continue;
                result.add(group);
            }
        }
        Collections.sort(result);
        return result;
    }

    public List<String> findVersionsByGroup(String group) {
        boolean debug = logger.isLoggable(Level.FINE);
        ArrayList<String> result = new ArrayList<String>();
        if (debug) {
            logger.log(Level.FINEST, "......searching model versions for workflowgroup ''{0}''...", group);
        }
        Collection<Model> models = this.getModelStore().values();
        for (Model amodel : models) {
            if (!amodel.getGroups().contains(group)) continue;
            result.add(amodel.getVersion());
        }
        Collections.sort(result, Collections.reverseOrder());
        return result;
    }

    public List<String> findVersionsByRegEx(String modelRegex) {
        boolean debug = logger.isLoggable(Level.FINE);
        ArrayList<String> result = new ArrayList<String>();
        if (debug) {
            logger.log(Level.FINEST, "......searching model versions for regex ''{0}''...", modelRegex);
        }
        Collection<Model> models = this.getModelStore().values();
        for (Model amodel : models) {
            if (!Pattern.compile(modelRegex).matcher(amodel.getVersion()).find()) continue;
            result.add(amodel.getVersion());
        }
        Collections.sort(result, Collections.reverseOrder());
        return result;
    }

    public void saveModel(BPMNModel model) throws ModelException {
        this.saveModel(model, null);
    }

    public void saveModel(BPMNModel model, String _filename) throws ModelException {
        if (model != null) {
            boolean debug = logger.isLoggable(Level.FINE);
            this.deleteModel(model.getVersion());
            if (debug) {
                logger.log(Level.FINEST, "......save BPMNModel ''{0}''...", model.getVersion());
            }
            BPMNModel bpmnModel = model;
            this.addModel((Model)model);
            ItemCollection modelItemCol = new ItemCollection();
            modelItemCol.replaceItemValue("type", (Object)"model");
            modelItemCol.replaceItemValue("$snapshot.history", (Object)1);
            modelItemCol.replaceItemValue("$creator", (Object)this.ctx.getCallerPrincipal().getName());
            modelItemCol.replaceItemValue("name", (Object)bpmnModel.getVersion());
            modelItemCol.replaceItemValue("namcreator", (Object)this.ctx.getCallerPrincipal().getName());
            modelItemCol.replaceItemValue("txtname", (Object)bpmnModel.getVersion());
            Object filename = _filename;
            if (filename == null || ((String)filename).isEmpty()) {
                filename = bpmnModel.getVersion() + ".bpmn";
            }
            FileData fileData = new FileData((String)filename, bpmnModel.getRawData(), "application/xml", null);
            modelItemCol.addFileData(fileData);
            modelItemCol.replaceItemValue("$noindex", (Object)true);
            this.documentService.save(modelItemCol);
            this.modelEntityStore.put(bpmnModel.getVersion(), modelItemCol);
        }
    }

    public void deleteModel(String version) {
        if (version != null && !version.isEmpty()) {
            boolean debug = logger.isLoggable(Level.FINE);
            if (debug) {
                logger.log(Level.FINEST, "......delete BPMNModel ''{0}''...", version);
            }
            List<ItemCollection> col = this.documentService.getDocumentsByType("model");
            for (ItemCollection modelEntity : col) {
                String oldVersion = modelEntity.getItemValueString("txtname");
                if (!version.equals(oldVersion)) continue;
                this.documentService.remove(modelEntity);
            }
        } else {
            logger.severe("deleteModel - invalid model version!");
            throw new InvalidAccessException("INVALID_ID", "deleteModel - invalid model version!");
        }
        this.removeModel(version);
        this.modelEntityStore.remove(version);
    }

    public ItemCollection findModelEntity(String version) {
        ItemCollection result = this.modelEntityStore.get(version);
        if (result == null) {
            logger.severe("invalid model version!");
            throw new InvalidAccessException("INVALID_ID", "findModelEntity - invalid model version: " + version);
        }
        return result;
    }

    public String getDataObject(ItemCollection bpmnElement, String name) {
        List dataObjects = bpmnElement.getItemValue("dataObjects");
        if (dataObjects != null && dataObjects.size() > 0) {
            for (List dataObject : dataObjects) {
                String key = (String)dataObject.get(0);
                if (!name.equals(key)) continue;
                return (String)dataObject.get(1);
            }
        }
        return null;
    }

    private Map<String, Model> getModelStore() {
        if (this.modelStore == null) {
            this.modelStore = new ConcurrentHashMap();
            this.init();
        }
        return this.modelStore;
    }
}

