/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine;

import jakarta.ejb.Stateless;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.Config;
import org.imixs.workflow.engine.TextEvent;
import org.imixs.workflow.util.XMLParser;

@Stateless
public class TextPropertyValueAdapter {
    @Inject
    private Config config;
    private static final Logger logger = Logger.getLogger(TextPropertyValueAdapter.class.getName());

    public void onEvent(@Observes TextEvent event) {
        Object text = event.getText();
        boolean debug = logger.isLoggable(Level.FINE);
        if (((String)text).contains("<propertyValue") || ((String)text).contains("</propertyValue>")) {
            logger.warning("Deprecated <propertyValue> tag should be lowercase <propertyvalue> !");
            text = ((String)text).replace("<propertyValue", "<propertyvalue");
            text = ((String)text).replace("</propertyValue>", "</propertyvalue>");
        }
        List tagList = XMLParser.findTags((String)text, (String)"propertyvalue");
        if (debug) {
            logger.log(Level.FINEST, "......{0} tags found", tagList.size());
        }
        for (String tag : tagList) {
            String sPropertyKey = XMLParser.findTagValue((String)tag, (String)"propertyvalue");
            String vValue = "";
            try {
                vValue = (String)this.config.getValue(sPropertyKey, String.class);
            }
            catch (NoSuchElementException e) {
                logger.log(Level.WARNING, "propertyvalue ''{0}'' is not defined in imixs.properties!", sPropertyKey);
                vValue = "";
            }
            int iStartPos = ((String)text).indexOf(tag);
            int iEndPos = ((String)text).indexOf(tag) + tag.length();
            text = ((String)text).substring(0, iStartPos) + vValue + ((String)text).substring(iEndPos);
        }
        event.setText((String)text);
    }

    public String formatItemValues(List<?> aItem, String aSeparator, String sFormat, Locale locale, String sPosition) {
        StringBuffer sBuffer = new StringBuffer();
        if (aItem == null || aItem.size() == 0) {
            return "";
        }
        if (sPosition == null || sPosition.isEmpty()) {
            for (Object aSingleValue : aItem) {
                String aValue = TextPropertyValueAdapter.formatObjectValue(aSingleValue, sFormat, locale);
                sBuffer.append(aValue);
                if (aSeparator != null) {
                    sBuffer.append(aSeparator);
                    continue;
                }
                break;
            }
        } else if ("last".equalsIgnoreCase(sPosition)) {
            sBuffer.append(aItem.get(aItem.size() - 1));
        } else {
            sBuffer.append(aItem.get(0));
        }
        String sString = sBuffer.toString();
        if (aSeparator != null && sString.endsWith(aSeparator)) {
            sString = sString.substring(0, sString.lastIndexOf(aSeparator));
        }
        return sString;
    }

    private static String formatObjectValue(Object o, String format, Locale locale) {
        Date dateValue = null;
        if (o instanceof Date) {
            dateValue = (Date)o;
        }
        if (o instanceof Calendar) {
            Calendar cal = (Calendar)o;
            dateValue = cal.getTime();
        }
        if (dateValue != null) {
            String singleValue = "";
            if (format != null && !"".equals(format)) {
                try {
                    SimpleDateFormat formatter = null;
                    formatter = locale != null ? new SimpleDateFormat(format, locale) : new SimpleDateFormat(format);
                    singleValue = formatter.format(dateValue);
                }
                catch (Exception ef) {
                    logger.log(Level.WARNING, "TextPropertyValueAdapter: Invalid format String ''{0}''", format);
                    logger.log(Level.WARNING, "TextPropertyValueAdapter: Can not format value - error: {0}", ef.getMessage());
                    return "" + dateValue;
                }
            } else {
                singleValue = DateFormat.getDateTimeInstance(3, 3).format(dateValue);
            }
            return singleValue;
        }
        return o.toString();
    }
}

