/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine;

import jakarta.annotation.Resource;
import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ejb.LocalBean;
import jakarta.ejb.SessionContext;
import jakarta.ejb.Stateless;
import jakarta.ejb.TransactionAttribute;
import jakarta.ejb.TransactionAttributeType;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.imixs.workflow.Adapter;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.Model;
import org.imixs.workflow.ModelManager;
import org.imixs.workflow.Plugin;
import org.imixs.workflow.WorkflowContext;
import org.imixs.workflow.WorkflowKernel;
import org.imixs.workflow.WorkflowManager;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.engine.ProcessingEvent;
import org.imixs.workflow.engine.ReportService;
import org.imixs.workflow.engine.TextEvent;
import org.imixs.workflow.engine.plugins.ResultPlugin;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.InvalidAccessException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.exceptions.QueryException;
import org.imixs.workflow.util.XMLParser;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
@LocalBean
public class WorkflowService
implements WorkflowManager,
WorkflowContext {
    public static final String UNIQUEIDREF = "$uniqueidref";
    public static final String READACCESS = "$readaccess";
    public static final String WRITEACCESS = "$writeaccess";
    public static final String PARTICIPANTS = "$participants";
    public static final String DEFAULT_TYPE = "workitem";
    public static final int SORT_ORDER_CREATED_DESC = 0;
    public static final int SORT_ORDER_CREATED_ASC = 1;
    public static final int SORT_ORDER_MODIFIED_DESC = 2;
    public static final int SORT_ORDER_MODIFIED_ASC = 3;
    public static final String INVALID_ITEMVALUE_FORMAT = "INVALID_ITEMVALUE_FORMAT";
    public static final String INVALID_TAG_FORMAT = "INVALID_TAG_FORMAT";
    @Inject
    @Any
    private Instance<Plugin> plugins;
    @Inject
    @Any
    protected Instance<Adapter> adapters;
    @Inject
    DocumentService documentService;
    @Inject
    ModelService modelService;
    @Inject
    ReportService reportService;
    @Resource
    SessionContext ctx;
    @Inject
    protected Event<ProcessingEvent> processingEvents;
    @Inject
    protected Event<TextEvent> textEvents;
    private static final Logger logger = Logger.getLogger(WorkflowService.class.getName());

    public ItemCollection getWorkItem(String uniqueid) {
        return this.documentService.load(uniqueid);
    }

    public List<ItemCollection> getWorkListByOwner(String name, String type, int pageSize, int pageIndex, String sortBy, boolean sortReverse) {
        if (name == null || "".equals(name)) {
            name = this.ctx.getCallerPrincipal().getName();
        }
        Object searchTerm = "(";
        if (type != null && !"".equals(type)) {
            searchTerm = (String)searchTerm + " type:\"" + type + "\" AND ";
        }
        searchTerm = (String)searchTerm + " (namowner:\"" + name + "\" OR $owner:\"" + name + "\") )";
        try {
            return this.documentService.find((String)searchTerm, pageSize, pageIndex, sortBy, sortReverse);
        }
        catch (QueryException e) {
            logger.log(Level.SEVERE, "getWorkListByOwner - invalid param: {0}", e.getMessage());
            return null;
        }
    }

    public List<ItemCollection> getWorkListByAuthor(String name, String type, int pageSize, int pageIndex, String sortBy, boolean sortReverse) {
        if (name == null || "".equals(name)) {
            name = this.ctx.getCallerPrincipal().getName();
        }
        Object searchTerm = "(";
        if (type != null && !"".equals(type)) {
            searchTerm = (String)searchTerm + " type:\"" + type + "\" AND ";
        }
        searchTerm = (String)searchTerm + " $writeaccess:\"" + name + "\" )";
        try {
            return this.documentService.find((String)searchTerm, pageSize, pageIndex, sortBy, sortReverse);
        }
        catch (QueryException e) {
            logger.log(Level.SEVERE, "getWorkListByAuthor - invalid param: {0}", e.getMessage());
            return null;
        }
    }

    public List<ItemCollection> getWorkListByCreator(String name, String type, int pageSize, int pageIndex, String sortBy, boolean sortReverse) {
        if (name == null || "".equals(name)) {
            name = this.ctx.getCallerPrincipal().getName();
        }
        Object searchTerm = "(";
        if (type != null && !"".equals(type)) {
            searchTerm = (String)searchTerm + " type:\"" + type + "\" AND ";
        }
        searchTerm = (String)searchTerm + " $creator:\"" + name + "\" )";
        try {
            return this.documentService.find((String)searchTerm, pageSize, pageIndex, sortBy, sortReverse);
        }
        catch (QueryException e) {
            logger.log(Level.SEVERE, "getWorkListByCreator - invalid param: {0}", e.getMessage());
            return null;
        }
    }

    public List<ItemCollection> getWorkListByWriteAccess(String type, int pageSize, int pageIndex, String sortBy, boolean sortReverse) {
        StringBuffer nameListBuffer = new StringBuffer();
        nameListBuffer.append("(");
        List<String> userNames = this.documentService.getUserNameList();
        for (int i = 0; i < userNames.size(); ++i) {
            String userName = userNames.get(i);
            if (i > 0) {
                nameListBuffer.append(" OR ");
            }
            nameListBuffer.append(" $writeaccess:\"" + userName + "\" ");
        }
        nameListBuffer.append(")");
        Object searchTerm = nameListBuffer.toString();
        if (type != null && !"".equals(type)) {
            searchTerm = (String)searchTerm + " AND type:\"" + type + "\"";
        }
        try {
            return this.documentService.find((String)searchTerm, pageSize, pageIndex, sortBy, sortReverse);
        }
        catch (QueryException e) {
            logger.log(Level.SEVERE, "getWorkListByWriteAccess - invalid param: {0}", e.getMessage());
            return null;
        }
    }

    public List<ItemCollection> getWorkListByGroup(String name, String type, int pageSize, int pageIndex, String sortBy, boolean sortReverse) {
        Object searchTerm = "(";
        if (type != null && !"".equals(type)) {
            searchTerm = (String)searchTerm + " type:\"" + type + "\" AND ";
        }
        searchTerm = (String)searchTerm + " ($workflowgroup:\"" + name + "\" OR txtworkflowgroup:\"" + name + "\") )";
        try {
            return this.documentService.find((String)searchTerm, pageSize, pageIndex, sortBy, sortReverse);
        }
        catch (QueryException e) {
            logger.log(Level.SEVERE, "getWorkListByGroup - invalid param: {0}", e.getMessage());
            return null;
        }
    }

    public List<ItemCollection> getWorkListByProcessID(int aid, String type, int pageSize, int pageIndex, String sortBy, boolean sortReverse) {
        Object searchTerm = "(";
        if (type != null && !"".equals(type)) {
            searchTerm = (String)searchTerm + " type:\"" + type + "\" AND ";
        }
        searchTerm = (String)searchTerm + " $processid:\"" + aid + "\" )";
        try {
            return this.documentService.find((String)searchTerm, pageSize, pageIndex, sortBy, sortReverse);
        }
        catch (QueryException e) {
            logger.log(Level.SEVERE, "getWorkListByProcessID - invalid param: {0}", e.getMessage());
            return null;
        }
    }

    public List<ItemCollection> getWorkListByRef(String aref, String type, int pageSize, int pageIndex, String sortBy, boolean sortReverse) {
        Object searchTerm = "(";
        if (type != null && !"".equals(type)) {
            searchTerm = (String)searchTerm + " type:\"" + type + "\" AND ";
        }
        searchTerm = (String)searchTerm + " $uniqueidref:\"" + aref + "\" )";
        try {
            return this.documentService.find((String)searchTerm, pageSize, pageIndex, sortBy, sortReverse);
        }
        catch (QueryException e) {
            logger.log(Level.SEVERE, "getWorkListByRef - invalid param: {0}", e.getMessage());
            return null;
        }
    }

    public List<ItemCollection> getWorkListByRef(String aref) {
        return this.getWorkListByRef(aref, null, 0, 0, null, false);
    }

    public List<ItemCollection> getEvents(ItemCollection workitem) throws ModelException {
        ArrayList<ItemCollection> result = new ArrayList<ItemCollection>();
        int processID = workitem.getTaskID();
        Model model = this.modelService.getModelByWorkitem(workitem);
        List eventList = model.findAllEventsByTask(processID);
        String username = this.getUserName();
        boolean bManagerAccess = this.ctx.isCallerInRole("org.imixs.ACCESSLEVEL.MANAGERACCESS");
        for (ItemCollection event : eventList) {
            if ("0".equals(event.getItemValueString("keypublicresult"))) continue;
            List restrictedList = event.getItemValue("keyRestrictedVisibility");
            if (!bManagerAccess && !restrictedList.isEmpty()) {
                ArrayList totalNameList = new ArrayList();
                for (String itemName : restrictedList) {
                    totalNameList.addAll(workitem.getItemValue(itemName));
                }
                totalNameList.removeAll(Collections.singleton(null));
                totalNameList.removeAll(Collections.singleton(""));
                if (!totalNameList.isEmpty() && !totalNameList.contains(username)) continue;
            }
            result.add(event);
        }
        return result;
    }

    public ItemCollection processWorkItem(ItemCollection workitem) throws AccessDeniedException, ProcessingErrorException, PluginException, ModelException {
        boolean debug = logger.isLoggable(Level.FINE);
        long lStartTime = System.currentTimeMillis();
        if (workitem == null) {
            throw new ProcessingErrorException(WorkflowService.class.getSimpleName(), "INVALID_WORKITEM", "workitem Is Null!");
        }
        if (this.processingEvents != null) {
            this.processingEvents.fire((Object)new ProcessingEvent(workitem, 1));
        } else {
            logger.warning("CDI Support is missing - ProcessingEvents Not Supported!");
        }
        if (!workitem.getUniqueID().isEmpty()) {
            ItemCollection currentInstance = this.getWorkItem(workitem.getUniqueID());
            if (currentInstance != null) {
                if (!currentInstance.getItemValueBoolean("$isAuthor")) {
                    throw new AccessDeniedException("OPERATION_NOTALLOWED", "$uniqueid: " + workitem.getItemValueInteger("$uniqueid") + " - No Author Access!");
                }
                if (workitem.getTaskID() > 0 && currentInstance.getTaskID() != workitem.getTaskID()) {
                    throw new ProcessingErrorException(WorkflowService.class.getSimpleName(), "INVALID_PROCESSID", "$uniqueid: " + workitem.getItemValueInteger("$uniqueid") + " - $taskid=" + workitem.getTaskID() + " Did Not Match Expected $taskid=" + currentInstance.getTaskID());
                }
                workitem.mergeItems(currentInstance.getAllItems());
            } else if (workitem.getTaskID() <= 0 || workitem.getEventID() <= 0 || workitem.getModelVersion().isEmpty() && workitem.getWorkflowGroup().isEmpty()) {
                throw new InvalidAccessException("OPERATION_NOTALLOWED", "$uniqueid: " + workitem.getItemValueInteger("$uniqueid") + " - Insufficient Data or Lack Of Permission!");
            }
        }
        if ("".equals(workitem.getType())) {
            workitem.replaceItemValue("type", (Object)DEFAULT_TYPE);
        }
        Model model = null;
        try {
            model = this.getModelManager().getModelByWorkitem(workitem);
        }
        catch (ModelException e) {
            throw new ProcessingErrorException(WorkflowService.class.getSimpleName(), "INVALID_PROCESSID", e.getMessage(), (Exception)((Object)e));
        }
        WorkflowKernel workflowkernel = new WorkflowKernel((WorkflowContext)this);
        this.registerPlugins(workflowkernel, model);
        this.registerAdapters(workflowkernel);
        this.updateMetadata(workitem);
        try {
            long lKernelTime = System.currentTimeMillis();
            workitem = workflowkernel.process(workitem);
            if (debug) {
                logger.log(Level.FINE, "...WorkflowKernel processing time={0}ms", System.currentTimeMillis() - lKernelTime);
            }
        }
        catch (PluginException pe) {
            logger.log(Level.SEVERE, "processing workitem ''{0} failed, rollback transaction...", workitem.getItemValueString("$uniqueid"));
            this.ctx.setRollbackOnly();
            throw pe;
        }
        if (this.processingEvents != null) {
            this.processingEvents.fire((Object)new ProcessingEvent(workitem, 2));
        }
        List splitWorkitems = workflowkernel.getSplitWorkitems();
        for (ItemCollection splitWorkitemm : splitWorkitems) {
            if (this.processingEvents != null) {
                this.processingEvents.fire((Object)new ProcessingEvent(splitWorkitemm, 2));
            }
            this.documentService.save(splitWorkitemm);
        }
        workitem = this.documentService.save(workitem);
        if (debug) {
            logger.log(Level.FINE, "...total processing time={0}ms", System.currentTimeMillis() - lStartTime);
        }
        return workitem;
    }

    public ItemCollection processWorkItem(ItemCollection workitem, ItemCollection event) throws AccessDeniedException, ProcessingErrorException, PluginException, ModelException {
        return this.processWorkItem(workitem, event.getItemValueInteger("numactivityid"));
    }

    public ItemCollection processWorkItem(ItemCollection workitem, int eventID) throws AccessDeniedException, ProcessingErrorException, PluginException, ModelException {
        workitem.setEventID(eventID);
        return this.processWorkItem(workitem);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public ItemCollection processWorkItemByNewTransaction(ItemCollection workitem) throws AccessDeniedException, ProcessingErrorException, PluginException, ModelException {
        boolean debug = logger.isLoggable(Level.FINE);
        if (debug) {
            logger.finest(" ....processing workitem by by new transaction...");
        }
        return this.processWorkItem(workitem);
    }

    public void removeWorkItem(ItemCollection aworkitem) throws AccessDeniedException {
        this.documentService.remove(aworkitem);
    }

    public ModelManager getModelManager() {
        return this.modelService;
    }

    public SessionContext getSessionContext() {
        return this.ctx;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public ReportService getReportService() {
        return this.reportService;
    }

    public String getUserName() {
        return this.ctx.getCallerPrincipal().getName();
    }

    public boolean isUserInRole(String rolename) {
        try {
            return this.ctx.isCallerInRole(rolename);
        }
        catch (Exception e) {
            return false;
        }
    }

    public List<String> getUserNameList() {
        return this.documentService.getUserNameList();
    }

    public String adaptText(String text, ItemCollection documentContext) throws PluginException {
        if (this.textEvents != null) {
            TextEvent event = new TextEvent(text, documentContext);
            this.textEvents.fire((Object)event);
            text = event.getText();
        } else {
            logger.warning("CDI Support is missing - TextEvent wil not be fired");
        }
        return text;
    }

    public List<String> adaptTextList(String text, ItemCollection documentContext) throws PluginException {
        if (this.textEvents != null) {
            TextEvent event = new TextEvent(text, documentContext);
            this.textEvents.fire((Object)event);
            return event.getTextList();
        }
        logger.warning("CDI Support is missing - TextEvent wil not be fired");
        ArrayList<String> textList = new ArrayList<String>();
        textList.add(text);
        return textList;
    }

    public ItemCollection evalWorkflowResult(ItemCollection event, String xmlTag, ItemCollection documentContext, boolean resolveItemValues) throws PluginException {
        boolean debug = logger.isLoggable(Level.FINE);
        ItemCollection result = new ItemCollection();
        String workflowResult = event.getItemValueString("txtActivityResult");
        if (workflowResult.trim().isEmpty()) {
            return null;
        }
        if (xmlTag == null || xmlTag.isEmpty()) {
            logger.warning("cannot eval workflow result - no tag name specified. Verify model!");
            return null;
        }
        if (workflowResult.indexOf("<" + xmlTag) == -1) {
            return null;
        }
        if (resolveItemValues) {
            workflowResult = this.adaptText(workflowResult, documentContext);
        }
        boolean invalidPattern = false;
        Pattern patternSimple = Pattern.compile("<" + xmlTag + " (.*?)>(.*?)|<" + xmlTag + " (.*?)./>", 32);
        Matcher matcherSimple = patternSimple.matcher(workflowResult);
        if (matcherSimple.find()) {
            invalidPattern = true;
            Pattern pattern = Pattern.compile("(?s)(?:(<" + xmlTag + "(?>\\b(?:\".*?\"|'.*?'|[^>]*?)*>)(?<=/>))|(<" + xmlTag + "(?>\\b(?:\".*?\"|'.*?'|[^>]*?)*>)(?<!/>))(.*?)(</" + xmlTag + "\\s*>))", 32);
            Matcher matcher = pattern.matcher(workflowResult);
            while (matcher.find()) {
                invalidPattern = false;
                String content = "";
                String attributes = matcher.group(1);
                if (attributes == null) {
                    attributes = matcher.group(2);
                    content = matcher.group(3);
                } else {
                    content = matcher.group(2);
                }
                if (content == null) {
                    content = "";
                }
                if (attributes != null && !attributes.isEmpty()) {
                    String spattern = "(\\S+)=[\"']?((?:.(?![\"']?\\s+(?:\\S+)=|[>\"']))+.)[\"']?";
                    Pattern attributePattern = Pattern.compile(spattern);
                    Matcher attributeMatcher = attributePattern.matcher(attributes);
                    HashMap<String, String> attrMap = new HashMap<String, String>();
                    while (attributeMatcher.find()) {
                        String attrName = attributeMatcher.group(1);
                        String attrValue = attributeMatcher.group(2);
                        attrMap.put(attrName, attrValue);
                    }
                    String tagName = (String)attrMap.get("name");
                    if (tagName == null) {
                        throw new PluginException(ResultPlugin.class.getSimpleName(), INVALID_TAG_FORMAT, "<" + xmlTag + "> tag contains no name attribute.");
                    }
                    for (String attrName : attrMap.keySet()) {
                        if ("name".equals(attrName)) continue;
                        result.appendItemValue(tagName + "." + attrName, attrMap.get(attrName));
                    }
                    String sType = result.getItemValueString(tagName + ".type");
                    String sFormat = result.getItemValueString(tagName + ".format");
                    if (!sType.isEmpty()) {
                        if ("boolean".equalsIgnoreCase(sType)) {
                            result.appendItemValue(tagName, (Object)Boolean.valueOf(content));
                            continue;
                        }
                        if ("integer".equalsIgnoreCase(sType)) {
                            try {
                                result.appendItemValue(tagName, (Object)Integer.valueOf(content));
                            }
                            catch (NumberFormatException e) {
                                result.appendItemValue(tagName, (Object)new Integer(0));
                            }
                            continue;
                        }
                        if ("double".equalsIgnoreCase(sType)) {
                            try {
                                result.appendItemValue(tagName, (Object)Double.valueOf(content));
                            }
                            catch (NumberFormatException e) {
                                result.appendItemValue(tagName, (Object)new Double(0.0));
                            }
                            continue;
                        }
                        if ("float".equalsIgnoreCase(sType)) {
                            try {
                                result.appendItemValue(tagName, (Object)Float.valueOf(content));
                            }
                            catch (NumberFormatException e) {
                                result.appendItemValue(tagName, (Object)new Float(0.0f));
                            }
                            continue;
                        }
                        if ("long".equalsIgnoreCase(sType)) {
                            try {
                                result.appendItemValue(tagName, (Object)Long.valueOf(content));
                            }
                            catch (NumberFormatException e) {
                                result.appendItemValue(tagName, (Object)new Long(0L));
                            }
                            continue;
                        }
                        if ("date".equalsIgnoreCase(sType)) {
                            if (content == null || content.isEmpty()) {
                                if (!debug) continue;
                                logger.finer("......can not convert empty string into date object");
                                continue;
                            }
                            try {
                                if (debug) {
                                    logger.finer("......convert string into date object");
                                }
                                Date dateResult = null;
                                if (sFormat == null || sFormat.isEmpty()) {
                                    dateResult = DateFormat.getDateTimeInstance(3, 3).parse(content);
                                } else {
                                    SimpleDateFormat dateFormat = new SimpleDateFormat(sFormat);
                                    dateResult = dateFormat.parse(content);
                                }
                                result.appendItemValue(tagName, (Object)dateResult);
                            }
                            catch (ParseException e) {
                                if (!debug) continue;
                                logger.log(Level.FINER, "failed to convert string into date object: {0}", e.getMessage());
                            }
                            continue;
                        }
                        result.appendItemValue(tagName, (Object)content);
                        continue;
                    }
                    result.appendItemValue(tagName, (Object)content);
                    continue;
                }
                throw new PluginException(ResultPlugin.class.getSimpleName(), INVALID_TAG_FORMAT, "<" + xmlTag + "> tag contains no name attribute.");
            }
        }
        if (invalidPattern) {
            throw new PluginException(ResultPlugin.class.getSimpleName(), INVALID_TAG_FORMAT, "invalid <" + xmlTag + "> tag format in workflowResult: " + workflowResult + "  , expected format is <" + xmlTag + " name=\"...\">...</item> ");
        }
        return result;
    }

    public ItemCollection evalWorkflowResult(ItemCollection event, String tag, ItemCollection documentContext) throws PluginException {
        return this.evalWorkflowResult(event, tag, documentContext, true);
    }

    public List<ItemCollection> evalWorkflowResultXML(ItemCollection event, String xmlTag, String name, ItemCollection documentContext, boolean resolveItemValues) throws PluginException {
        ArrayList<ItemCollection> result = new ArrayList<ItemCollection>();
        ItemCollection configItemCol = this.evalWorkflowResult(event, xmlTag, documentContext, resolveItemValues);
        if (configItemCol == null) {
            throw new PluginException(WorkflowService.class.getSimpleName(), INVALID_TAG_FORMAT, "Missing XML definition '" + xmlTag + "' in Event " + event.getItemValueInteger("numprocessid") + "." + event.getItemValueInteger("numactivityid"));
        }
        List xmlDefinitions = configItemCol.getItemValueList(name, String.class);
        if (xmlDefinitions != null) {
            for (String definitionXML : xmlDefinitions) {
                ItemCollection xmlItemCol;
                if (definitionXML.trim().isEmpty() || (xmlItemCol = XMLParser.parseItemStructure((String)definitionXML)) == null) continue;
                result.add(xmlItemCol);
            }
        }
        return result;
    }

    @Deprecated
    public ItemCollection evalWorkflowResult(ItemCollection event, ItemCollection documentContext, boolean resolveItemValues) throws PluginException {
        logger.warning("Method call evalWorkflowResult(event, workitem, resolve) is deprecated, use method evalWorkflowResult(event, tag, workitem, resolve) instead!");
        return this.evalWorkflowResult(event, "item", documentContext, resolveItemValues);
    }

    @Deprecated
    public ItemCollection evalWorkflowResult(ItemCollection event, ItemCollection documentContext) throws PluginException {
        logger.warning("Method call evalWorkflowResult(event, workitem) is deprecated, use method evalWorkflowResult(event, tag, workitem) instead!");
        return this.evalWorkflowResult(event, "item", documentContext);
    }

    public ItemCollection evalNextTask(ItemCollection documentContext) throws PluginException, ModelException {
        WorkflowKernel workflowkernel = new WorkflowKernel((WorkflowContext)this);
        int taskID = workflowkernel.eval(documentContext);
        ItemCollection task = this.getModelManager().getModel(documentContext.getModelVersion()).getTask(taskID);
        return task;
    }

    protected void registerPlugins(WorkflowKernel workflowkernel, Model model) throws PluginException {
        boolean debug = logger.isLoggable(Level.FINE);
        ItemCollection profile = model.getDefinition();
        List vPlugins = profile.getItemValue("txtPlugins");
        for (int i = 0; i < vPlugins.size(); ++i) {
            String aPluginClassName = (String)vPlugins.get(i);
            Plugin aPlugin = this.findPluginByName(aPluginClassName);
            if (aPlugin != null) {
                if (debug) {
                    logger.log(Level.FINEST, "......register CDI plugin class: {0}...", aPluginClassName);
                }
                workflowkernel.registerPlugin(aPlugin);
                continue;
            }
            workflowkernel.registerPlugin(aPluginClassName);
        }
    }

    protected void registerAdapters(WorkflowKernel workflowkernel) {
        boolean debug = logger.isLoggable(Level.FINE);
        if (debug && (this.adapters == null || !this.adapters.iterator().hasNext())) {
            logger.finest("......no CDI Adapters injected");
        } else {
            for (Adapter adapter : this.adapters) {
                if (debug) {
                    logger.log(Level.FINEST, "......register CDI Adapter class ''{0}''", adapter.getClass().getName());
                }
                workflowkernel.registerAdapter(adapter);
            }
        }
    }

    protected void updateMetadata(ItemCollection workitem) {
        String nameEditor = this.ctx.getCallerPrincipal().getName();
        if (workitem.getItemValueString("$creator").isEmpty() && !workitem.getItemValueString("namCreator").isEmpty()) {
            workitem.replaceItemValue("$creator", (Object)workitem.getItemValue("namCreator"));
        }
        if (workitem.getItemValueString("$creator").isEmpty()) {
            workitem.replaceItemValue("$creator", (Object)nameEditor);
            workitem.replaceItemValue("namCreator", (Object)nameEditor);
        }
        if (!nameEditor.equals(workitem.getItemValueString("$editor")) && !workitem.getItemValueString("$editor").isEmpty()) {
            workitem.replaceItemValue("$lasteditor", (Object)workitem.getItemValueString("$editor"));
            workitem.replaceItemValue("namlasteditor", (Object)workitem.getItemValueString("$editor"));
        }
        workitem.replaceItemValue("$editor", (Object)nameEditor);
        workitem.replaceItemValue("namcurrenteditor", (Object)nameEditor);
    }

    private Plugin findPluginByName(String pluginClassName) {
        if (pluginClassName == null || pluginClassName.isEmpty()) {
            return null;
        }
        boolean debug = logger.isLoggable(Level.FINE);
        if (this.plugins == null || !this.plugins.iterator().hasNext()) {
            if (debug) {
                logger.finest("......no CDI plugins injected");
            }
            return null;
        }
        for (Plugin plugin : this.plugins) {
            if (!plugin.getClass().getName().equals(pluginClassName)) continue;
            if (debug) {
                logger.log(Level.FINEST, "......CDI plugin ''{0}'' successful injected", pluginClassName);
            }
            return plugin;
        }
        return null;
    }
}

