/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.plugins;

import jakarta.inject.Inject;
import java.util.Calendar;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.EventLogService;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.util.XMLParser;

public class EventLogPlugin
extends AbstractPlugin {
    public static final String INVALID_FORMAT = "INVALID_FORMAT";
    private static final Logger logger = Logger.getLogger(EventLogPlugin.class.getName());
    @Inject
    EventLogService eventLogService;

    public ItemCollection run(ItemCollection documentContext, ItemCollection event) throws PluginException {
        ItemCollection eventLogConfig = this.getWorkflowService().evalWorkflowResult(event, "eventlog", documentContext, true);
        if (eventLogConfig == null || eventLogConfig.getItemNames().size() == 0) {
            return documentContext;
        }
        for (String name : eventLogConfig.getItemNames()) {
            String xmlDef = eventLogConfig.getItemValueString(name);
            ItemCollection eventLogData = XMLParser.parseItemStructure((String)xmlDef);
            if (eventLogData == null) continue;
            String ref = eventLogData.getItemValueString("ref");
            String documentXML = eventLogData.getItemValueString("document");
            long timeout = eventLogData.getItemValueLong("timeout");
            Calendar cal = null;
            if (timeout > 0L) {
                cal = Calendar.getInstance();
                cal.setTimeInMillis(System.currentTimeMillis() + timeout);
            }
            if (!documentXML.isEmpty()) {
                ItemCollection docData = XMLParser.parseItemStructure((String)documentXML);
                this.eventLogService.createEvent(name, ref, docData.getAllItems(), cal);
                continue;
            }
            this.eventLogService.createEvent(name, ref, cal);
        }
        return documentContext;
    }
}

