/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.plugins;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.exceptions.PluginException;

public class HistoryPlugin
extends AbstractPlugin {
    private ItemCollection documentContext;
    private static final Logger logger = Logger.getLogger(HistoryPlugin.class.getName());
    public static final String ITEM_HISTORY_LOG = "workflow.history";

    public ItemCollection run(ItemCollection adocumentContext, ItemCollection adocumentActivity) throws PluginException {
        String rtfItemLog;
        this.documentContext = adocumentContext;
        ItemCollection documentActivity = adocumentActivity;
        if (this.documentContext.hasItem("txtworkflowhistorylogrev")) {
            this.convertOldFormat();
            this.documentContext.removeItem("txtworkflowhistorylogrev");
        }
        if ((rtfItemLog = documentActivity.getItemValueString("rtfresultlog")).isEmpty()) {
            return this.documentContext;
        }
        rtfItemLog = this.getWorkflowService().adaptText(rtfItemLog, this.documentContext);
        List temp = null;
        temp = !this.documentContext.hasItem(ITEM_HISTORY_LOG) && this.documentContext.hasItem("txtworkflowhistory") ? this.documentContext.getItemValue("txtworkflowhistory") : this.documentContext.getItemValue(ITEM_HISTORY_LOG);
        ArrayList<Object> newEntry = new ArrayList<Object>();
        newEntry.add(this.documentContext.getItemValueDate("$lasteventdate"));
        newEntry.add(rtfItemLog);
        newEntry.add(this.getWorkflowService().getUserName());
        temp.add(newEntry);
        Collections.sort(temp, new Comparator<List<?>>(){

            @Override
            public int compare(List<?> entry1, List<?> entry2) {
                Date date1 = (Date)entry1.get(0);
                Date date2 = (Date)entry2.get(0);
                return date1.compareTo(date2);
            }
        });
        this.documentContext.replaceItemValue(ITEM_HISTORY_LOG, (Object)temp);
        this.documentContext.replaceItemValue("txtworkflowhistory", (Object)temp);
        return this.documentContext;
    }

    protected void convertOldFormat() {
        ArrayList newList = new ArrayList();
        try {
            List oldList = this.documentContext.getItemValue("txtworkflowhistorylog");
            for (String oldEntry : oldList) {
                if (oldEntry == null || oldEntry.isEmpty() || oldEntry.indexOf(" : ") <= -1) continue;
                String sDate = oldEntry.substring(0, oldEntry.indexOf(" : "));
                String sComment = oldEntry.substring(oldEntry.indexOf(" : ") + 3);
                String sUser = "";
                ArrayList<Object> newEntry = new ArrayList<Object>();
                newEntry.add(this.convertDate(sDate));
                newEntry.add(sComment);
                newEntry.add(sUser);
                newList.add(newEntry);
            }
        }
        catch (ClassCastException cce) {
            logger.warning("[HistoryPlugin] can not convert txtworkflowhistorylog into new format!");
            logger.warning(cce.getMessage());
        }
        this.documentContext.replaceItemValue("txtworkflowhistory", newList);
    }

    private Date convertDate(String aDateString) {
        DateFormat df = null;
        try {
            df = DateFormat.getDateTimeInstance(1, 1, new Locale("de", "DE"));
            Date result = df.parse(aDateString);
            return result;
        }
        catch (ParseException parseException) {
            try {
                df = DateFormat.getDateTimeInstance(2, 2, new Locale("de", "DE"));
                Date result = df.parse(aDateString);
                return result;
            }
            catch (ParseException parseException2) {
                try {
                    df = DateFormat.getDateTimeInstance(3, 3, new Locale("de", "DE"));
                    Date result = df.parse(aDateString);
                    return result;
                }
                catch (ParseException parseException3) {
                    try {
                        df = DateFormat.getDateTimeInstance(1, 2, new Locale("de", "DE"));
                        Date result = df.parse(aDateString);
                        return result;
                    }
                    catch (ParseException parseException4) {
                        try {
                            df = DateFormat.getDateTimeInstance(2, 3, new Locale("de", "DE"));
                            Date result = df.parse(aDateString);
                            return result;
                        }
                        catch (ParseException parseException5) {
                            try {
                                df = DateFormat.getDateTimeInstance(3, 2, new Locale("de", "DE"));
                                Date result = df.parse(aDateString);
                                return result;
                            }
                            catch (ParseException parseException6) {
                                try {
                                    df = DateFormat.getDateTimeInstance(2, 1, new Locale("de", "DE"));
                                    Date result = df.parse(aDateString);
                                    return result;
                                }
                                catch (ParseException parseException7) {
                                    return null;
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

