/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.plugins;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.RuleEngine;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.exceptions.PluginException;

public class RulePlugin
extends AbstractPlugin {
    public static final String INVALID_SCRIPT = "INVALID_SCRIPT";
    public static final String VALIDATION_ERROR = "VALIDATION_ERROR";
    private static final Logger logger = Logger.getLogger(RulePlugin.class.getName());

    public ItemCollection run(ItemCollection workitem, ItemCollection event) throws PluginException {
        String script = event.getItemValueString("txtBusinessRule");
        if ("".equals(script.trim())) {
            return workitem;
        }
        String sEngineType = event.getItemValueString("txtBusinessRuleEngine");
        RuleEngine ruleEngine = new RuleEngine(sEngineType);
        ItemCollection result = ruleEngine.evaluateBusinessRule(script, workitem, event);
        if (result == null) {
            logger.warning("Business Rule does not return a result object: " + script);
        } else {
            Double d;
            Long followUpActivity;
            Boolean isValidActivity = true;
            if (result.hasItem("isValid")) {
                isValidActivity = result.getItemValueBoolean("isValid");
                result.removeItem("isValid");
            }
            if (isValidActivity != null && !isValidActivity.booleanValue()) {
                String sErrorCode = VALIDATION_ERROR;
                String oErrorCode = null;
                if (result.hasItem("errorCode")) {
                    oErrorCode = result.getItemValueString("errorCode");
                    result.removeItem("errorCode");
                }
                if (oErrorCode != null && oErrorCode instanceof String) {
                    sErrorCode = oErrorCode.toString();
                }
                Object[] params = null;
                if (result.hasItem("errorMessage")) {
                    params = result.getItemValue("errorMessage").toArray();
                    result.removeItem("errorMessage");
                }
                throw new PluginException(RulePlugin.class.getName(), sErrorCode, "BusinessRule: validation failed - ErrorCode=" + sErrorCode, params);
            }
            String followUp = null;
            if (result.hasItem("followUp")) {
                followUp = result.getItemValueString("followUp");
                result.removeItem("followUp");
            }
            if (followUp != null && (followUpActivity = Long.valueOf((d = Double.valueOf(followUp.toString())).longValue())) != null && followUpActivity > 0L) {
                event.replaceItemValue("keyFollowUp", (Object)"1");
                event.replaceItemValue("numNextActivityID", (Object)followUpActivity);
            }
            for (Map.Entry entry : result.getAllItems().entrySet()) {
                String itemName = (String)entry.getKey();
                if (itemName.startsWith("$")) continue;
                logger.log(Level.FINEST, "......Update item ''{0}''", itemName);
                workitem.replaceItemValue(itemName, entry.getValue());
            }
        }
        return workitem;
    }
}

