/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.scheduler;

import jakarta.annotation.Resource;
import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.RunAs;
import jakarta.ejb.SessionContext;
import jakarta.ejb.Stateless;
import jakarta.ejb.TransactionAttribute;
import jakarta.ejb.TransactionAttributeType;
import jakarta.inject.Inject;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RunAs(value="org.imixs.ACCESSLEVEL.MANAGERACCESS")
@Stateless
public class SchedulerConfigurationService {
    @Resource
    SessionContext ctx;
    @Inject
    DocumentService documentService;
    private static final Logger logger = Logger.getLogger(SchedulerConfigurationService.class.getName());

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void storeConfigurationInNewTransaction(ItemCollection config) {
        logger.finest(" ....saving scheduler configuration by new transaciton...");
        config.removeItem("$version");
        config = this.documentService.save(config);
    }
}

