/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.scheduler;

import jakarta.annotation.Resource;
import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.RunAs;
import jakarta.ejb.ScheduleExpression;
import jakarta.ejb.SessionContext;
import jakarta.ejb.Stateless;
import jakarta.ejb.Timeout;
import jakarta.ejb.Timer;
import jakarta.ejb.TimerConfig;
import jakarta.ejb.TimerService;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.scheduler.Scheduler;
import org.imixs.workflow.engine.scheduler.SchedulerConfigurationService;
import org.imixs.workflow.engine.scheduler.SchedulerException;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.InvalidAccessException;
import org.imixs.workflow.exceptions.QueryException;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RunAs(value="org.imixs.ACCESSLEVEL.MANAGERACCESS")
@Stateless
public class SchedulerService {
    public static final String DOCUMENT_TYPE = "scheduler";
    @Resource
    SessionContext ctx;
    @Inject
    DocumentService documentService;
    @Resource
    TimerService timerService;
    @Inject
    SchedulerConfigurationService schedulerSaveService;
    @Inject
    @Any
    private Instance<Scheduler> schedulerHandlers;
    private static final Logger logger = Logger.getLogger(SchedulerService.class.getName());

    public ItemCollection loadConfiguration(String name) {
        try {
            String sQuery = "(type:\"scheduler\" AND (name:\"" + name + "\" OR txtname:\"" + name + "\" ) )";
            List<ItemCollection> col = this.documentService.find(sQuery, 1, 0);
            if (col.size() > 0) {
                ItemCollection configuration = (ItemCollection)col.iterator().next();
                this.updateTimerDetails(configuration);
                return configuration;
            }
        }
        catch (QueryException e1) {
            e1.printStackTrace();
        }
        return null;
    }

    public ItemCollection saveConfiguration(ItemCollection configItemCollection) {
        String name = configItemCollection.getItemValueString("name");
        if (name.isEmpty()) {
            name = configItemCollection.getItemValueString("txtname");
            configItemCollection.replaceItemValue("name", (Object)name);
        }
        if (name == null || name.isEmpty()) {
            throw new InvalidAccessException(SchedulerService.class.getName(), "INVALID_WORKITEM", " scheduler configuraiton must contain the item 'name'");
        }
        configItemCollection.replaceItemValue("type", (Object)DOCUMENT_TYPE);
        configItemCollection.replaceItemValue("$snapshot.history", (Object)1);
        configItemCollection.replaceItemValue("$writeAccess", (Object)"org.imixs.ACCESSLEVEL.MANAGERACCESS");
        configItemCollection.replaceItemValue("$readAccess", (Object)"org.imixs.ACCESSLEVEL.MANAGERACCESS");
        this.updateTimerDetails(configItemCollection);
        configItemCollection = this.documentService.save(configItemCollection);
        return configItemCollection;
    }

    public ItemCollection start(ItemCollection configuration) throws AccessDeniedException, ParseException {
        Timer timer = null;
        if (configuration == null) {
            return null;
        }
        String id = configuration.getUniqueID();
        timer = this.findTimer(id);
        if (timer != null) {
            try {
                timer.cancel();
                timer = null;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "...failed to stop existing timer for ''{0}''!", configuration.getUniqueID());
                throw new InvalidAccessException(SchedulerService.class.getName(), "INVALID_WORKITEM", " failed to cancle existing timer!");
            }
        }
        logger.log(Level.INFO, "...Scheduler Service {0} will be started...", configuration.getUniqueID());
        String schedulerDescription = configuration.getItemValueString("_scheduler_definition");
        if (!schedulerDescription.isEmpty()) {
            timer = this.createTimerOnCalendar(configuration);
        }
        if (timer != null) {
            Calendar calNow = Calendar.getInstance();
            SimpleDateFormat dateFormatDE = new SimpleDateFormat("dd.MM.yy hh:mm:ss");
            String msg = "started at " + dateFormatDE.format(calNow.getTime()) + " by " + this.ctx.getCallerPrincipal().getName();
            configuration.replaceItemValue("_scheduler_status", (Object)msg);
            logger.log(Level.INFO, "...Scheduler Service {0} ({1}) successfull started.", new Object[]{id, configuration.getItemValueString("Name")});
        }
        configuration.replaceItemValue("_scheduler_enabled", (Object)true);
        configuration.replaceItemValue("_scheduler_errormessage", (Object)"");
        configuration.replaceItemValue("_scheduler_logmessage", (Object)"");
        return configuration;
    }

    public ItemCollection stop(ItemCollection configuration) {
        Timer timer = this.findTimer(configuration.getUniqueID());
        return this.stop(configuration, timer);
    }

    public ItemCollection stop(ItemCollection configuration, Timer timer) {
        if (timer != null) {
            try {
                timer.cancel();
            }
            catch (Exception e) {
                logger.log(Level.INFO, "...failed to stop timer for ''{0}''!", configuration.getUniqueID());
            }
            Calendar calNow = Calendar.getInstance();
            SimpleDateFormat dateFormatDE = new SimpleDateFormat("dd.MM.yy hh:mm:ss");
            String message = "stopped at " + dateFormatDE.format(calNow.getTime());
            String name = this.ctx.getCallerPrincipal().getName();
            if (name != null && !name.isEmpty() && !"anonymous".equals(name)) {
                message = message + " by " + name;
            }
            configuration.replaceItemValue("_scheduler_status", (Object)message);
            logger.log(Level.INFO, "... scheduler {0} stopped: {1}", new Object[]{configuration.getItemValueString("Name"), configuration.getUniqueID()});
        } else {
            String msg = "stopped";
            configuration.replaceItemValue("_scheduler_status", (Object)msg);
        }
        configuration.removeItem("nextTimeout");
        configuration.removeItem("timeRemaining");
        configuration.replaceItemValue("_scheduler_enabled", (Object)false);
        Calendar cal = Calendar.getInstance();
        configuration.appendItemValue("_scheduler_logmessage", (Object)("Stopped: " + cal.getTime()));
        return configuration;
    }

    public void startAllSchedulers() {
        logger.info("...starting Imixs Schedulers....");
        List<ItemCollection> col = this.documentService.getDocumentsByType(DOCUMENT_TYPE);
        if (col.size() > 100) {
            logger.severe("More than 100 waiting scheduler jobs found but a maximum of 100 jobs will be started in parallel. Please report this issue to the imixs-workflow project!");
        }
        for (ItemCollection schedulerConfig : col) {
            if (schedulerConfig != null && schedulerConfig.getItemValueBoolean("_scheduler_enabled")) {
                try {
                    if (this.findTimer(schedulerConfig.getUniqueID()) == null) {
                        this.start(schedulerConfig);
                        continue;
                    }
                    logger.log(Level.INFO, "...Scheduler Service {0} already running. ", schedulerConfig.getUniqueID());
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "...start of Scheduler Service {0} failed! - {1}", new Object[]{schedulerConfig.getUniqueID(), e.getMessage()});
                    e.printStackTrace();
                }
                continue;
            }
            logger.log(Level.INFO, "...Scheduler Service {0} is not enabled. ", schedulerConfig.getUniqueID());
        }
    }

    public Timer findTimer(String id) {
        for (Object obj : this.timerService.getTimers()) {
            Timer timer = (Timer)obj;
            if (!id.equals(timer.getInfo())) continue;
            return timer;
        }
        return null;
    }

    public void updateTimerDetails(ItemCollection configuration) {
        if (configuration == null) {
            return;
        }
        String id = configuration.getUniqueID();
        try {
            Timer timer = this.findTimer(id);
            if (timer != null) {
                configuration.replaceItemValue("nextTimeout", (Object)timer.getNextTimeout());
                configuration.replaceItemValue("timeRemaining", (Object)timer.getTimeRemaining());
            } else {
                configuration.removeItem("nextTimeout");
                configuration.removeItem("timeRemaining");
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "unable to updateTimerDetails: {0}", e.getMessage());
            configuration.removeItem("nextTimeout");
            configuration.removeItem("timeRemaining");
        }
    }

    public void logMessage(String message, ItemCollection configuration, ItemCollection workitem) {
        if (configuration != null) {
            configuration.appendItemValue("_scheduler_logmessage", (Object)message);
        }
        if (workitem != null) {
            workitem.appendItemValue("_scheduler_logmessage", (Object)message);
        }
        logger.info(message);
    }

    public void logWarning(String message, ItemCollection configuration, ItemCollection workitem) {
        if (configuration != null) {
            configuration.appendItemValue("_scheduler_logmessage", (Object)message);
        }
        if (workitem != null) {
            workitem.appendItemValue("_scheduler_logmessage", (Object)message);
        }
        logger.warning(message);
    }

    protected Scheduler findSchedulerByName(String schedulerClassName) {
        if (schedulerClassName == null || schedulerClassName.isEmpty()) {
            return null;
        }
        boolean debug = logger.isLoggable(Level.FINE);
        if (this.schedulerHandlers == null || !this.schedulerHandlers.iterator().hasNext()) {
            if (debug) {
                logger.finest("......no CDI schedulers injected");
            }
            return null;
        }
        logger.log(Level.FINEST, "......injecting CDI Scheduler ''{0}''...", schedulerClassName);
        for (Scheduler scheduler : this.schedulerHandlers) {
            if (!scheduler.getClass().getName().equals(schedulerClassName)) continue;
            if (debug) {
                logger.log(Level.FINEST, "......CDI Scheduler class ''{0}'' successful injected", schedulerClassName);
            }
            return scheduler;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Timeout
    protected void onTimeout(Timer timer) {
        Object errorMes = "";
        long lProfiler = System.currentTimeMillis();
        String id = timer.getInfo().toString();
        ItemCollection configuration = this.documentService.load(id);
        if (configuration == null) {
            logger.severe("...failed to load scheduler configuration for current timer. Timer will be stopped...");
            timer.cancel();
            return;
        }
        try {
            String schedulerClassName = configuration.getItemValueString("_scheduler_class");
            Scheduler scheduler = this.findSchedulerByName(schedulerClassName);
            if (scheduler != null) {
                logger.log(Level.INFO, "...run scheduler ''{0}'' scheduler class=''{1}''....", new Object[]{id, schedulerClassName});
                Calendar cal = Calendar.getInstance();
                configuration.replaceItemValue("_scheduler_logmessage", (Object)("Started: " + cal.getTime()));
                configuration = scheduler.run(configuration);
                logger.log(Level.INFO, "...run scheduler  ''{0}'' finished in: {1} ms", new Object[]{id, System.currentTimeMillis() - lProfiler});
                cal = Calendar.getInstance();
                configuration.appendItemValue("_scheduler_logmessage", (Object)("Finished: " + cal.getTime()));
                if (!configuration.getItemValueBoolean("_scheduler_enabled")) {
                    logger.log(Level.INFO, "...scheduler ''{0}'' disabled -> timer will be stopped...", id);
                    this.stop(configuration);
                }
            } else {
                errorMes = "Scheduler class='" + schedulerClassName + "' not found!";
                logger.log(Level.WARNING, "...scheduler ''{0}'' scheduler class=''{1}'' not found, timer will be stopped...", new Object[]{id, schedulerClassName});
                configuration.setItemValue("_scheduler_enabled", (Object)false);
                this.stop(configuration);
            }
        }
        catch (SchedulerException e) {
            if (logger.isLoggable(Level.FINEST)) {
                e.printStackTrace();
            }
            errorMes = e.getMessage();
            logger.log(Level.SEVERE, "Scheduler ''{0}'' failed: {1}", new Object[]{id, errorMes});
            configuration.appendItemValue("_scheduler_logmessage", (Object)("Error: " + (String)errorMes));
            configuration = this.stop(configuration, timer);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            errorMes = e.getMessage();
            logger.log(Level.SEVERE, "Scheduler ''{0}'' failed: {1}", new Object[]{id, errorMes});
            configuration.appendItemValue("_scheduler_logmessage", (Object)("Error: " + (String)errorMes));
        }
        finally {
            if (configuration != null) {
                configuration.replaceItemValue("_scheduler_errormessage", errorMes);
                this.schedulerSaveService.storeConfigurationInNewTransaction(configuration);
            }
        }
    }

    protected Timer createTimerOnCalendar(ItemCollection configItemCollection) throws ParseException {
        TimerConfig timerConfig = new TimerConfig();
        timerConfig.setInfo((Serializable)((Object)configItemCollection.getUniqueID()));
        ScheduleExpression scheduerExpression = new ScheduleExpression();
        List calendarConfiguation = configItemCollection.getItemValue("_scheduler_definition");
        for (String confgEntry : calendarConfiguation) {
            Date convertedDate;
            SimpleDateFormat dateFormat;
            if (confgEntry.startsWith("second=")) {
                scheduerExpression.second(confgEntry.substring(confgEntry.indexOf(61) + 1));
            }
            if (confgEntry.startsWith("minute=")) {
                scheduerExpression.minute(confgEntry.substring(confgEntry.indexOf(61) + 1));
            }
            if (confgEntry.startsWith("hour=")) {
                scheduerExpression.hour(confgEntry.substring(confgEntry.indexOf(61) + 1));
            }
            if (confgEntry.startsWith("dayOfWeek=")) {
                scheduerExpression.dayOfWeek(confgEntry.substring(confgEntry.indexOf(61) + 1));
            }
            if (confgEntry.startsWith("dayOfMonth=")) {
                scheduerExpression.dayOfMonth(confgEntry.substring(confgEntry.indexOf(61) + 1));
            }
            if (confgEntry.startsWith("month=")) {
                scheduerExpression.month(confgEntry.substring(confgEntry.indexOf(61) + 1));
            }
            if (confgEntry.startsWith("year=")) {
                scheduerExpression.year(confgEntry.substring(confgEntry.indexOf(61) + 1));
            }
            if (confgEntry.startsWith("timezone=")) {
                scheduerExpression.timezone(confgEntry.substring(confgEntry.indexOf(61) + 1));
            }
            if (confgEntry.startsWith("start=")) {
                dateFormat = new SimpleDateFormat("yyyy/MM/dd");
                convertedDate = dateFormat.parse(confgEntry.substring(confgEntry.indexOf(61) + 1));
                scheduerExpression.start(convertedDate);
            }
            if (!confgEntry.startsWith("end=")) continue;
            dateFormat = new SimpleDateFormat("yyyy/MM/dd");
            convertedDate = dateFormat.parse(confgEntry.substring(confgEntry.indexOf(61) + 1));
            scheduerExpression.end(convertedDate);
        }
        Timer timer = this.timerService.createCalendarTimer(scheduerExpression, timerConfig);
        return timer;
    }
}

