/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jee.faces;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.ejb.EJB;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIParameter;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.jee.ejb.EntityService;
import org.imixs.workflow.jee.ejb.ModelService;
import org.imixs.workflow.jee.ejb.WorkflowService;

public abstract class AbstractWorkflowController {
    protected ItemCollection workitemItemCollection = null;
    private String type;
    private ArrayList<ItemCollection> activityList;
    private ArrayList<ItemCollection> startProcessList = null;
    private String modelVersion = null;
    private ArrayList<ItemCollection> workitems = null;
    private int maxSearchResult = 10;
    private int row = 0;
    private boolean endOfList = false;
    private int queryType = 0;
    private String searchQuery = null;
    final int QUERY_WORKLIST_BY_OWNER = 0;
    final int QUERY_WORKLIST_BY_CREATOR = 1;
    final int QUERY_WORKLIST_BY_AUTHOR = 2;
    final int QUERY_WORKLIST_ALL = 3;
    final int QUERY_WORKLIST_ARCHIVE = 4;
    final int QUERY_SEARCH = 5;
    final int QUERY_WORKLIST_BY_WRITEACCESS = 6;
    private int sortOrder = 0;
    @EJB
    private EntityService entityService;
    @EJB
    private ModelService modelService;
    @EJB
    private WorkflowService workflowService;

    public AbstractWorkflowController() {
        this.setType("workitem");
        this.workitemItemCollection = new ItemCollection();
    }

    public EntityService getEntityService() {
        return this.entityService;
    }

    public ModelService getModelService() {
        return this.modelService;
    }

    public WorkflowService getWorkflowService() {
        return this.workflowService;
    }

    public String getID() {
        if (this.workitemItemCollection == null) {
            return null;
        }
        return this.workitemItemCollection.getItemValueString("$uniqueid");
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(int sortOrder) {
        this.sortOrder = sortOrder;
    }

    public String getModelVersion() {
        if (this.modelVersion == null) {
            try {
                this.modelVersion = this.modelService.getLatestVersion();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return this.modelVersion;
    }

    public void setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
    }

    public int getMaxSearchResult() {
        return this.maxSearchResult;
    }

    public void setMaxSearchResult(int searchCount) {
        this.maxSearchResult = searchCount;
    }

    public String getSearchQuery() {
        return this.searchQuery;
    }

    public void setSearchQuery(String query) {
        this.searchQuery = query;
    }

    public void setWorkitem(ItemCollection aworkitem) {
        this.workitemItemCollection = aworkitem != null ? aworkitem : new ItemCollection();
    }

    public ItemCollection getWorkitem() {
        return this.workitemItemCollection;
    }

    public void doCreateWorkitem(ActionEvent event) throws Exception {
        List children = event.getComponent().getChildren();
        String processEntityIdentifier = "";
        for (int i = 0; i < children.size(); ++i) {
            UIParameter currentParam;
            if (!(children.get(i) instanceof UIParameter) || !(currentParam = (UIParameter)children.get(i)).getName().equals("id") || currentParam.getValue() == null) continue;
            processEntityIdentifier = currentParam.getValue().toString();
            break;
        }
        if (processEntityIdentifier != null && !"".equals(processEntityIdentifier)) {
            String sProcessModelVersion = null;
            String sProcessID = processEntityIdentifier;
            if (processEntityIdentifier.indexOf(124) > -1) {
                sProcessModelVersion = processEntityIdentifier.substring(0, processEntityIdentifier.indexOf(124));
                sProcessID = processEntityIdentifier.substring(processEntityIdentifier.indexOf(124) + 1);
                this.setModelVersion(sProcessModelVersion);
            }
            this.doCreateWorkitem(Integer.parseInt(sProcessID));
        } else {
            this.workitemItemCollection = new ItemCollection();
            FacesContext context = FacesContext.getCurrentInstance();
            ExternalContext externalContext = context.getExternalContext();
            String sUser = externalContext.getRemoteUser();
            this.workitemItemCollection.replaceItemValue("namCreator", (Object)sUser);
            this.workitemItemCollection.replaceItemValue("type", (Object)this.getType());
            this.setWorkitem(this.workitemItemCollection);
        }
    }

    public void doCreateWorkitem(int ProcessID) throws Exception {
        ItemCollection itemColProcessEntity = null;
        try {
            itemColProcessEntity = this.modelService.getProcessEntityByVersion(ProcessID, this.getModelVersion());
            if (itemColProcessEntity == null) {
                throw new NullPointerException();
            }
        }
        catch (Exception eproc) {
            throw new Exception("unable to find ProcessEntity in model version " + this.getModelVersion() + " for ID=" + ProcessID);
        }
        String sEditorID = itemColProcessEntity.getItemValueString("txteditorid");
        int processID = itemColProcessEntity.getItemValueInteger("numProcessID");
        String sWorkflowGroup = itemColProcessEntity.getItemValueString("txtworkflowgroup");
        this.workitemItemCollection = new ItemCollection();
        this.workitemItemCollection.replaceItemValue("$ProcessID", (Object)new Integer(processID));
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext externalContext = context.getExternalContext();
        String sUser = externalContext.getRemoteUser();
        this.workitemItemCollection.replaceItemValue("namCreator", (Object)sUser);
        this.workitemItemCollection.replaceItemValue("$WriteAccess", (Object)sUser);
        this.workitemItemCollection.replaceItemValue("$modelversion", (Object)this.getModelVersion());
        this.workitemItemCollection.replaceItemValue("txtworkflowgroup", (Object)sWorkflowGroup);
        this.workitemItemCollection.replaceItemValue("txteditorid", (Object)sEditorID);
        this.workitemItemCollection.replaceItemValue("type", (Object)this.getType());
        this.setWorkitem(this.workitemItemCollection);
    }

    public void doProcessWorkitem(ActionEvent event) throws Exception {
        List children = event.getComponent().getChildren();
        int activityID = -1;
        for (int i = 0; i < children.size(); ++i) {
            UIParameter currentParam;
            if (!(children.get(i) instanceof UIParameter) || !(currentParam = (UIParameter)children.get(i)).getName().equals("id") || currentParam.getValue() == null) continue;
            activityID = Integer.parseInt(currentParam.getValue().toString());
            break;
        }
        this.workitemItemCollection.replaceItemValue("type", (Object)this.getType());
        this.workitemItemCollection.replaceItemValue("$activityid", (Object)activityID);
        this.workitemItemCollection = this.workflowService.processWorkItem(this.workitemItemCollection);
        this.setWorkitem(this.workitemItemCollection);
        this.doReset(event);
    }

    public void doEdit(ActionEvent event) {
        ItemCollection currentSelection = null;
        UIComponent component = event.getComponent();
        for (UIComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof UIData)) continue;
            currentSelection = (ItemCollection)((UIData)parent).getRowData();
            this.setWorkitem(currentSelection);
            break;
        }
    }

    public void doDelete(ActionEvent event) throws Exception {
        ItemCollection currentSelection = null;
        UIComponent component = event.getComponent();
        for (UIComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof UIData)) continue;
            currentSelection = (ItemCollection)((UIData)parent).getRowData();
            break;
        }
        if (currentSelection == null) {
            currentSelection = this.workitemItemCollection;
        }
        if (currentSelection != null) {
            this.deleteChilds(currentSelection);
            this.entityService.remove(currentSelection);
            this.setWorkitem(null);
            this.doReset(event);
        }
    }

    private void deleteChilds(ItemCollection parent) {
        try {
            String id = parent.getItemValueString("$uniqueid");
            String sQuery = null;
            sQuery = "SELECT";
            sQuery = sQuery + " wi FROM Entity as wi JOIN wi.textItems as t WHERE ";
            sQuery = sQuery + " t.itemName = '$uniqueidref' and t.itemValue = '" + id + "'";
            Collection col = this.entityService.findAllEntities(sQuery, 0, -1);
            for (ItemCollection aworkitem : col) {
                this.deleteChilds(aworkitem);
                this.entityService.remove(aworkitem);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doReset(ActionEvent event) {
        this.workitems = null;
        this.row = 0;
    }

    public void doRefresh(ActionEvent event) {
        this.workitems = null;
    }

    public void doSwitchToWorklistByAuthor(ActionEvent event) {
        this.queryType = this.QUERY_WORKLIST_BY_AUTHOR;
        this.doReset(event);
    }

    public void doSwitchToWorklistByWriteAccess(ActionEvent event) {
        this.queryType = this.QUERY_WORKLIST_BY_WRITEACCESS;
        this.doReset(event);
    }

    public void doSwitchToWorklistByOwner(ActionEvent event) {
        this.queryType = this.QUERY_WORKLIST_BY_OWNER;
        this.doReset(event);
    }

    public void doSwitchToWorklistByCreator(ActionEvent event) {
        this.queryType = this.QUERY_WORKLIST_BY_CREATOR;
        this.doReset(event);
    }

    public void doSwitchToWorklistAll(ActionEvent event) {
        this.queryType = this.QUERY_WORKLIST_ALL;
        this.doReset(event);
    }

    public void doSwitchToSearchlist(ActionEvent event) {
        this.queryType = this.QUERY_SEARCH;
        this.doReset(event);
    }

    public void doLoadNext(ActionEvent event) {
        this.row += this.maxSearchResult;
        this.workitems = null;
    }

    public void doLoadPrev(ActionEvent event) {
        this.row -= this.maxSearchResult;
        if (this.row < 0) {
            this.row = 0;
        }
        this.workitems = null;
    }

    public List<ItemCollection> getWorkitems() {
        if (this.workitems == null) {
            this.loadWorkItemList();
        }
        return this.workitems;
    }

    public void setWorkitems(ArrayList<ItemCollection> workitems) {
        this.workitems = workitems;
    }

    public int getRow() {
        return this.row;
    }

    public boolean isEndOfList() {
        return this.endOfList;
    }

    private void loadWorkItemList() {
        this.workitems = new ArrayList();
        List<ItemCollection> col = null;
        try {
            long lTime = System.currentTimeMillis();
            switch (this.queryType) {
                case 0: {
                    col = this.findWorkitemsByOwner(this.row, this.maxSearchResult);
                    break;
                }
                case 1: {
                    col = this.findWorkitemsByCreator(this.row, this.maxSearchResult);
                    break;
                }
                case 2: {
                    col = this.findWorkitemsByAuthor(this.row, this.maxSearchResult);
                    break;
                }
                case 6: {
                    col = this.findWorkitemsByWriteAccess(this.row, this.maxSearchResult);
                    break;
                }
                case 5: {
                    col = this.findWorkitemsByQuery(this.getSearchQuery(), this.row, this.maxSearchResult);
                    break;
                }
                default: {
                    col = this.findAllWorkitems(this.row, this.maxSearchResult);
                }
            }
            lTime = System.currentTimeMillis() - lTime;
            System.out.println("  loadWorkItemList (" + lTime + " ms)");
            this.endOfList = col.size() < this.maxSearchResult;
            for (ItemCollection aworkitem : col) {
                this.workitems.add(aworkitem);
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        this.setWorkitem(null);
    }

    private List<ItemCollection> findWorkitemsByQuery(String query, int row, int count) {
        ArrayList<ItemCollection> workitemList = new ArrayList<ItemCollection>();
        if (query == null || "".equals(query)) {
            return workitemList;
        }
        Collection col = this.entityService.findAllEntities(query, row, count);
        workitemList.addAll(col);
        return workitemList;
    }

    private List<ItemCollection> findWorkitemsByOwner(int row, int count) throws Exception {
        ArrayList<ItemCollection> workList = new ArrayList<ItemCollection>();
        Collection col = this.workflowService.getWorkListByOwner(null, row, count, this.type, this.getSortOrder());
        workList.addAll(col);
        return workList;
    }

    private List<ItemCollection> findWorkitemsByAuthor(int row, int count) throws Exception {
        ArrayList<ItemCollection> workList = new ArrayList<ItemCollection>();
        Collection col = this.workflowService.getWorkList(null, row, count, this.type, this.getSortOrder());
        workList.addAll(col);
        return workList;
    }

    private List<ItemCollection> findWorkitemsByWriteAccess(int row, int count) throws Exception {
        ArrayList<ItemCollection> workList = new ArrayList<ItemCollection>();
        Collection col = this.workflowService.getWorkListByWriteAccess(row, count, this.type, this.getSortOrder());
        workList.addAll(col);
        return workList;
    }

    private List<ItemCollection> findWorkitemsByCreator(int row, int count) throws Exception {
        ArrayList<ItemCollection> workList = new ArrayList<ItemCollection>();
        Collection col = this.workflowService.getWorkListByCreator(null, row, count, this.type, this.getSortOrder());
        workList.addAll(col);
        return workList;
    }

    private List<ItemCollection> findAllWorkitems(int row, int count) {
        ArrayList<ItemCollection> teamList = new ArrayList<ItemCollection>();
        String sQuery = "SELECT wi FROM Entity AS wi  WHERE wi.type= '" + this.getType() + "' ORDER BY wi.modified desc";
        Collection col = this.entityService.findAllEntities(sQuery, row, count);
        teamList.addAll(col);
        return teamList;
    }

    public String getWorkflowResult() {
        if (this.workitemItemCollection == null) {
            return "show_worklist";
        }
        String sResult = this.workitemItemCollection.getItemValueString("txtworkflowresultmessage");
        if (sResult == null || "".equals(sResult)) {
            return "show_worklist";
        }
        return sResult;
    }

    public ArrayList<ItemCollection> getActivities() {
        this.activityList = new ArrayList();
        if (this.workitemItemCollection == null) {
            return this.activityList;
        }
        int processId = this.workitemItemCollection.getItemValueInteger("$processid");
        String sversion = this.workitemItemCollection.getItemValueString("$modelversion");
        List col = sversion != null && !"".equals(sversion) ? this.modelService.getPublicActivitiesByVersion(processId, sversion) : this.modelService.getPublicActivitiesByVersion(processId, this.getModelVersion());
        for (ItemCollection aworkitem : col) {
            this.activityList.add(aworkitem);
        }
        return this.activityList;
    }

    public ArrayList<ItemCollection> getStartProcessList() {
        if (this.startProcessList != null) {
            return this.startProcessList;
        }
        this.startProcessList = new ArrayList();
        List col = this.modelService.getAllStartProcessEntitiesByVersion(this.getModelVersion());
        for (ItemCollection aworkitem : col) {
            this.startProcessList.add(aworkitem);
        }
        return this.startProcessList;
    }

    public boolean isNewWorkitem() {
        try {
            return !this.workitemItemCollection.hasItem("numlastactivityid");
        }
        catch (Exception e) {
            return true;
        }
    }

    public void addMessage(String ressourceBundleName, String messageKey, Object param) {
        String msgPattern;
        FacesContext context = FacesContext.getCurrentInstance();
        Locale locale = context.getViewRoot().getLocale();
        ResourceBundle rb = ResourceBundle.getBundle(ressourceBundleName, locale);
        String msg = msgPattern = rb.getString(messageKey);
        if (param != null) {
            Object[] params = new Object[]{param};
            msg = MessageFormat.format(msgPattern, params);
        }
        FacesMessage facesMsg = new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, msg);
        context.addMessage(null, facesMsg);
    }
}

