/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jee.faces.fileupload;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.enterprise.context.SessionScoped;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.jee.ejb.EntityService;
import org.imixs.workflow.jee.faces.fileupload.FileData;
import org.imixs.workflow.jee.faces.fileupload.MultipartRequestWrapper;

@Named(value="fileUploadController")
@SessionScoped
public class FileUploadController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<FileData> uploadedFiles = new ArrayList<FileData>();
    private List<String> attachedFiles;
    private List<String> removedFiles;
    private boolean dirty;
    private String restServiceURI;
    private String workitemID;
    private static Logger logger = Logger.getLogger("org.imixs.workflow");
    @EJB
    EntityService entityService;

    public String getRestServiceURI() {
        return this.restServiceURI;
    }

    public void setRestServiceURI(String restServiceURI) {
        this.restServiceURI = restServiceURI;
    }

    public String getWorkitemID() {
        return this.workitemID;
    }

    public void setWorkitemID(String workitemID) {
        this.workitemID = workitemID;
    }

    public List<String> getAttachedFiles() {
        if (this.attachedFiles == null) {
            this.attachedFiles = new ArrayList<String>();
        }
        return this.attachedFiles;
    }

    public void setAttachedFiles(List<String> attachedFiles) {
        this.attachedFiles = attachedFiles;
    }

    public List<String> getRemovedFiles() {
        if (this.removedFiles == null) {
            this.removedFiles = new ArrayList<String>();
        }
        return this.removedFiles;
    }

    public void setRemovedFiles(List<String> removedFiles) {
        this.removedFiles = removedFiles;
    }

    public List<FileData> getUploadedFiles() {
        if (this.uploadedFiles == null) {
            this.uploadedFiles = new ArrayList<FileData>();
        }
        return this.uploadedFiles;
    }

    public void doUpload(ActionEvent e) {
        logger.fine("FileUploadBean - doUpload...");
        HttpServletRequest req = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
        if (req instanceof MultipartRequestWrapper) {
            FileData fileData;
            MultipartRequestWrapper multi = (MultipartRequestWrapper)req;
            if (this.uploadedFiles == null) {
                this.uploadedFiles = new ArrayList<FileData>();
            }
            if ((fileData = multi.findFile("imixsFileUpload")) != null) {
                logger.fine("FileName: " + fileData.getName());
                logger.fine("ContentType: " + fileData.getContentType());
                logger.fine("Size: " + fileData.getSize());
                this.uploadedFiles.add(fileData);
                this.dirty = true;
            }
        }
    }

    public String removeAttachmentAction(String sFilename) {
        this.getRemovedFiles().add(sFilename);
        this.getAttachedFiles().remove(sFilename);
        this.dirty = true;
        return null;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void doClear(ActionEvent e) {
        logger.fine("FileUploadBean - clear uploadedFiles...");
        this.uploadedFiles = null;
        this.removedFiles = null;
        this.dirty = false;
    }

    public void updateWorkitem(ItemCollection workitem, boolean noContent) {
        if (!this.getRemovedFiles().isEmpty()) {
            for (String aFilename : this.getRemovedFiles()) {
                workitem.removeFile(aFilename);
            }
        }
        if (!this.getUploadedFiles().isEmpty()) {
            for (FileData aFile : this.getUploadedFiles()) {
                if (noContent) {
                    byte[] empty = new byte[]{0};
                    workitem.addFile(empty, aFile.getName(), "");
                    continue;
                }
                workitem.addFile(aFile.getData(), aFile.getName(), aFile.getContentType());
            }
        }
    }
}

