/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jee.faces.fileupload;

import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import org.imixs.workflow.jee.faces.fileupload.MultipartRequestWrapper;

@WebFilter(urlPatterns={"/*"})
public class MultipartRequestFilter
implements Filter {
    private static final String REQUEST_METHOD_POST = "POST";
    private static final String CONTENT_TYPE_MULTIPART = "multipart/";
    private static Logger logger = Logger.getLogger("org.imixs.workflow");

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String sContentType = request.getContentType();
        logger.fine("MulitpartRequestFilter : contentType=" + sContentType);
        if (REQUEST_METHOD_POST.equalsIgnoreCase(httpRequest.getMethod()) && request.getContentType() != null && sContentType.toLowerCase().startsWith(CONTENT_TYPE_MULTIPART)) {
            logger.fine("Is multipart request.... wrapping it.");
            request = new MultipartRequestWrapper(httpRequest);
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

