/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jee.faces.fileupload;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.Part;
import org.imixs.workflow.jee.faces.fileupload.FileData;

public class MultipartRequestWrapper
extends HttpServletRequestWrapper {
    private static final String CONTENT_DISPOSITION = "content-disposition";
    private static final String CONTENT_DISPOSITION_FILENAME = "filename";
    private static Logger logger = Logger.getLogger("org.imixs.workflow");
    private Hashtable<String, String[]> params = new Hashtable();

    public MultipartRequestWrapper(HttpServletRequest request) {
        super(request);
        logger.fine("Created multipart wrapper....");
        try {
            logger.fine("Looping parts");
            for (Part p : request.getParts()) {
                byte[] b = new byte[(int)p.getSize()];
                p.getInputStream().read(b);
                p.getInputStream().close();
                this.params.put(p.getName(), new String[]{new String(b)});
            }
        }
        catch (IOException ex) {
            Logger.getLogger(MultipartRequestWrapper.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ServletException ex) {
            Logger.getLogger(MultipartRequestWrapper.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public FileData findFile(String attrName) {
        FileData uf = null;
        try {
            Part p = this.findPart(attrName);
            if (p != null) {
                String fileName = this.getFilename(p);
                logger.fine("Filename : " + fileName + ", contentType " + p.getContentType());
                byte[] b = new byte[(int)p.getSize()];
                p.getInputStream().read(b);
                p.getInputStream().close();
                this.params.put(p.getName(), new String[]{new String(b)});
                uf = new FileData(fileName, p.getContentType(), b);
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        return uf;
    }

    private Part findPart(String name) {
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Part p = null;
        try {
            for (Part part : request.getParts()) {
                if (!part.getName().equals(name)) continue;
                p = part;
                break;
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        catch (ServletException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        return p;
    }

    private String getFilename(Part part) {
        for (String cd : part.getHeader(CONTENT_DISPOSITION).split(";")) {
            if (!cd.trim().startsWith(CONTENT_DISPOSITION_FILENAME)) continue;
            return cd.substring(cd.indexOf(61) + 1).trim().replace("\"", "");
        }
        return null;
    }

    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public Map<String, String[]> getParameterMap() {
        return this.params;
    }

    public Enumeration<String> getParameterNames() {
        return this.params.keys();
    }

    public String[] getParameterValues(String name) {
        return this.params.get(name);
    }
}

