/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jee.faces.workitem;

import java.util.ArrayList;
import java.util.List;
import javax.ejb.EJB;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.InvalidAccessException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.jee.ejb.ModelService;
import org.imixs.workflow.jee.ejb.WorkflowService;
import org.imixs.workflow.jee.faces.workitem.DataController;

public class WorkflowController
extends DataController {
    private static final long serialVersionUID = 1L;
    private List<ItemCollection> activityList;
    @EJB
    private ModelService modelService;
    @EJB
    private WorkflowService workflowService;

    public WorkflowController() {
        this.setType("workitem");
    }

    public ModelService getModelService() {
        return this.modelService;
    }

    public WorkflowService getWorkflowService() {
        return this.workflowService;
    }

    @Override
    public void setWorkitem(ItemCollection aworkitem) {
        super.setWorkitem(aworkitem);
        this.activityList = null;
    }

    public String init(String action) {
        List col;
        ItemCollection startProcessEntity = null;
        this.activityList = null;
        if (!this.getWorkitem().hasItem("$ModelVersion")) {
            String modelVersion;
            try {
                modelVersion = this.modelService.getLatestVersion();
            }
            catch (ModelException e) {
                throw new InvalidAccessException(e.getErrorContext(), e.getErrorCode(), e.getMessage(), (Exception)((Object)e));
            }
            this.getWorkitem().replaceItemValue("$ModelVersion", (Object)modelVersion);
        }
        if (this.getWorkitem().getItemValueInteger("$ProcessID") <= 0 && !(col = this.modelService.getAllStartProcessEntitiesByVersion(this.getWorkitem().getItemValueString("$ModelVersion"))).isEmpty()) {
            startProcessEntity = (ItemCollection)col.iterator().next();
            this.getWorkitem().replaceItemValue("$ProcessID", (Object)startProcessEntity.getItemValueInteger("numProcessID"));
        }
        if ((startProcessEntity = this.modelService.getProcessEntityByVersion(this.getWorkitem().getItemValueInteger("$ProcessID"), this.getWorkitem().getItemValueString("$ModelVersion"))) == null) {
            throw new InvalidAccessException("INVALID_MODEL_ENTRY", "unable to find ProcessEntity in model version " + this.getWorkitem().getItemValueString("$ModelVersion") + " for ID=" + this.getWorkitem().getItemValueInteger("$ProcessID"));
        }
        this.getWorkitem().replaceItemValue("$WriteAccess", (Object)this.getWorkitem().getItemValue("namCreator"));
        this.getWorkitem().replaceItemValue("txtworkflowgroup", (Object)startProcessEntity.getItemValueString("txtworkflowgroup"));
        this.getWorkitem().replaceItemValue("txtworkflowStatus", (Object)startProcessEntity.getItemValueString("txtname"));
        this.getWorkitem().replaceItemValue("txtWorkflowImageURL", (Object)startProcessEntity.getItemValueString("txtimageurl"));
        this.getWorkitem().replaceItemValue("txtWorkflowEditorid", (Object)startProcessEntity.getItemValueString("txteditorid"));
        return action;
    }

    public String process() throws AccessDeniedException, ProcessingErrorException, PluginException {
        this.workitem.removeItem("action");
        this.workitem = this.getWorkflowService().processWorkItem(this.workitem);
        this.activityList = null;
        String action = this.workitem.getItemValueString("action");
        if ("".equals(action)) {
            action = this.workitem.getItemValueString("txtworkflowresultmessage");
        }
        return "".equals(action) ? null : action;
    }

    public String process(int id) throws AccessDeniedException, ProcessingErrorException, PluginException {
        return this.process(id, false);
    }

    public String process(int id, boolean resetWorkitem) throws AccessDeniedException, ProcessingErrorException, PluginException {
        this.getWorkitem().replaceItemValue("$ActivityID", (Object)id);
        String result = this.process();
        if (resetWorkitem) {
            this.reset(null);
        }
        return result;
    }

    @Override
    public String save(String action) throws AccessDeniedException {
        try {
            return this.process();
        }
        catch (ProcessingErrorException e) {
            throw new InvalidAccessException(e.getErrorContext(), e.getErrorCode(), e.getMessage(), (Exception)((Object)e));
        }
        catch (PluginException e) {
            throw new InvalidAccessException(e.getErrorContext(), e.getErrorCode(), e.getMessage(), (Exception)((Object)e));
        }
    }

    public String getAction() {
        String action = this.getWorkitem().getItemValueString("txtworkflowresultmessage");
        return "".equals(action) ? null : action;
    }

    public List<ItemCollection> getActivities() {
        if (this.activityList != null) {
            return this.activityList;
        }
        this.activityList = new ArrayList<ItemCollection>();
        if (this.getWorkitem() == null) {
            return this.activityList;
        }
        int processId = this.getWorkitem().getItemValueInteger("$processid");
        if (processId == 0) {
            return this.activityList;
        }
        String sversion = this.getWorkitem().getItemValueString("$modelversion");
        List col = null;
        if (sversion != null && !"".equals(sversion)) {
            col = this.getModelService().getPublicActivitiesByVersion(processId, sversion);
        }
        for (ItemCollection aworkitem : col) {
            this.activityList.add(aworkitem);
        }
        return this.activityList;
    }

    @Override
    public boolean isNewWorkitem() {
        try {
            return !this.getWorkitem().hasItem("numlastactivityid");
        }
        catch (Exception e) {
            return true;
        }
    }
}

