/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jee.faces.workitem;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.faces.application.FacesMessage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.jee.ejb.EntityService;

public class DataController
implements Serializable {
    private static final long serialVersionUID = 1L;
    ItemCollection workitem = null;
    private String type;
    @EJB
    EntityService entityService;
    private static Logger logger = Logger.getLogger("org.imixs.workflow");

    public DataController() {
        this.setType("workitem");
    }

    public EntityService getEntityService() {
        return this.entityService;
    }

    public String getID() {
        return this.getWorkitem().getItemValueString("$uniqueid");
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ItemCollection getWorkitem() {
        return this.workitem;
    }

    public void setWorkitem(ItemCollection workitem) {
        this.workitem = workitem;
    }

    public void create(ActionEvent event) {
        ItemCollection newWorkitem = new ItemCollection();
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext externalContext = context.getExternalContext();
        String sUser = externalContext.getRemoteUser();
        newWorkitem.replaceItemValue("namCreator", (Object)sUser);
        newWorkitem.replaceItemValue("type", (Object)this.getType());
        this.setWorkitem(newWorkitem);
        logger.fine("ItemCollection created");
    }

    public void save() throws AccessDeniedException {
        this.workitem = this.getEntityService().save(this.workitem);
        logger.fine("ItemCollection saved");
    }

    public String save(String action) throws AccessDeniedException {
        this.save();
        return action;
    }

    public void reset() {
        this.setWorkitem(null);
    }

    public void reset(ActionEvent event) {
        this.reset();
    }

    public void load(String uniqueID) {
        this.setWorkitem(this.getEntityService().load(uniqueID));
        logger.fine("ItemCollection '" + uniqueID + "' loaded");
    }

    public String load(String uniqueID, String action) {
        this.load(uniqueID);
        return action;
    }

    public String delete(String uniqueID, String action) throws AccessDeniedException {
        this.delete(uniqueID);
        return action;
    }

    public void delete(String uniqueID) throws AccessDeniedException {
        ItemCollection currentSelection = this.getEntityService().load(uniqueID);
        if (currentSelection != null) {
            this.deleteChilds(currentSelection);
            this.entityService.remove(currentSelection);
        }
        this.setWorkitem(null);
        logger.fine("ItemCollection " + uniqueID + " delted");
    }

    public void deleteChilds(ItemCollection parent) {
        try {
            String id = parent.getItemValueString("$uniqueid");
            String sQuery = null;
            sQuery = "SELECT";
            sQuery = sQuery + " wi FROM Entity as wi JOIN wi.textItems as t WHERE ";
            sQuery = sQuery + " t.itemName = '$uniqueidref' and t.itemValue = '" + id + "'";
            List col = this.entityService.findAllEntities(sQuery, 0, -1);
            for (ItemCollection aworkitem : col) {
                this.deleteChilds(aworkitem);
                this.entityService.remove(aworkitem);
            }
            logger.fine("childs for: " + id + " deleted");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isNewWorkitem() {
        try {
            return !this.getWorkitem().hasItem("$unqiueid");
        }
        catch (Exception e) {
            return true;
        }
    }

    public void addMessage(String ressourceBundleName, String messageKey, Object param) {
        String msgPattern;
        FacesContext context = FacesContext.getCurrentInstance();
        Locale locale = context.getViewRoot().getLocale();
        ResourceBundle rb = ResourceBundle.getBundle(ressourceBundleName, locale);
        String msg = msgPattern = rb.getString(messageKey);
        if (param != null) {
            Object[] params = new Object[]{param};
            msg = MessageFormat.format(msgPattern, params);
        }
        FacesMessage facesMsg = new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, msg);
        context.addMessage(null, facesMsg);
    }
}

