/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jee.faces.workitem;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.faces.event.ActionEvent;
import javax.faces.event.AjaxBehaviorEvent;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.jee.ejb.EntityService;
import org.imixs.workflow.jee.faces.workitem.IViewAdapter;

public class ViewController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String type = null;
    private int maxResult = 10;
    private int row = 0;
    private boolean endOfList = false;
    private Map<String, String> views = new HashMap<String, String>();
    private String view = null;
    private List<ItemCollection> workitems = null;
    private IViewAdapter viewAdapter = null;
    @EJB
    EntityService entityService;
    private static Logger logger = Logger.getLogger("org.imixs.workflow");

    public ViewController() {
        this.setType("workitem");
        this.setView("worklist.created.desc");
    }

    @PostConstruct
    public void init() {
        if (this.views.get("worklist.created.desc") == null) {
            this.views.put("worklist.created.desc", "SELECT wi FROM Entity AS wi  WHERE wi.type= '" + this.getType() + "' ORDER BY wi.created desc");
        }
        if (this.views.get("worklist.modified.desc") == null) {
            this.views.put("worklist.modified.desc", "SELECT wi FROM Entity AS wi  WHERE wi.type= '" + this.getType() + "'  ORDER BY wi.modified desc");
        }
        if (this.views.get("worklist.name.asc") == null) {
            this.views.put("worklist.name.asc", "SELECT wi FROM Entity as wi JOIN wi.textItems as t WHERE  wi.type='" + this.getType() + "' " + " AND t.itemName = 'txtname'\tORDER BY t.itemValue ");
        }
    }

    public EntityService getEntityService() {
        return this.entityService;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Map<String, String> getViews() {
        return this.views;
    }

    public void setViews(Map<String, String> views) {
        this.views = views;
    }

    public String getView() {
        return this.view;
    }

    public void setView(String view) {
        this.view = view;
        this.doReset();
    }

    public int getMaxResult() {
        return this.maxResult;
    }

    public void setMaxResult(int searchCount) {
        this.maxResult = searchCount;
    }

    public void doReset() {
        this.workitems = null;
        this.row = 0;
    }

    public void doReset(ActionEvent event) {
        this.doReset();
    }

    public void doReset(AjaxBehaviorEvent event) {
        this.doReset();
    }

    public void doRefresh() {
        this.workitems = null;
    }

    public void doRefresh(ActionEvent event) {
        this.doRefresh();
    }

    public void doRefresh(AjaxBehaviorEvent event) {
        this.doRefresh();
    }

    public void doLoadNext() {
        this.row += this.maxResult;
        this.workitems = null;
    }

    public void doLoadNext(ActionEvent event) {
        this.doLoadNext();
    }

    public void doLoadNext(AjaxBehaviorEvent event) {
        this.doLoadNext();
    }

    public void doLoadPrev() {
        this.row -= this.maxResult;
        if (this.row < 0) {
            this.row = 0;
        }
        this.workitems = null;
    }

    public void doLoadPrev(ActionEvent event) {
        this.doLoadPrev();
    }

    public void doLoadPrev(AjaxBehaviorEvent event) {
        this.doLoadPrev();
    }

    public List<ItemCollection> getWorkitems() {
        if (this.workitems != null) {
            return this.workitems;
        }
        long lTime = System.currentTimeMillis();
        this.workitems = this.getViewAdapter().getViewEntries(this);
        if (this.workitems == null) {
            this.workitems = new ArrayList<ItemCollection>();
        }
        this.endOfList = this.workitems.size() < this.maxResult;
        lTime = System.currentTimeMillis() - lTime;
        logger.finest("  getWorkitems (" + lTime + " ms)");
        return this.workitems;
    }

    public void setWorkitems(List<ItemCollection> workitems) {
        this.workitems = workitems;
    }

    public int getRow() {
        return this.row;
    }

    public boolean isEndOfList() {
        return this.endOfList;
    }

    public void setEndOfList(boolean endOfList) {
        this.endOfList = endOfList;
    }

    public IViewAdapter getViewAdapter() {
        if (this.viewAdapter == null) {
            this.viewAdapter = new ViewAdapter();
        }
        return this.viewAdapter;
    }

    public void setViewAdapter(IViewAdapter viewAdapter) {
        this.viewAdapter = viewAdapter;
    }

    protected class ViewAdapter
    implements IViewAdapter {
        protected ViewAdapter() {
        }

        @Override
        public List<ItemCollection> getViewEntries(ViewController controller) {
            List result = controller.getEntityService().findAllEntities((String)controller.views.get(controller.view), controller.row, controller.maxResult);
            return result;
        }
    }
}

