/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jee.faces.fileupload;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.imixs.workflow.jee.faces.fileupload.FileData;

@WebServlet(urlPatterns={"/fileupload/*"})
@MultipartConfig(fileSizeThreshold=0x100000, maxFileSize=0x6400000L, maxRequestSize=524288000L)
public class AjaxFileUploadServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String REQUEST_METHOD_POST = "POST";
    private static final String REQUEST_METHOD_GET = "GET";
    private static final String CONTENT_TYPE_MULTIPART = "multipart/";
    private static final String CONTENT_DISPOSITION = "content-disposition";
    private static final String CONTENT_DISPOSITION_FILENAME = "filename";
    public static final String IMIXS_FILEDATA_LIST = "IMIXS_FILEDATA_LIST";
    private List<FileData> fileDataList = null;
    private static Logger logger = Logger.getLogger(AjaxFileUploadServlet.class.getName());

    protected void doPost(HttpServletRequest httpRequest, HttpServletResponse response) throws ServletException, IOException {
        if (this.isPostFileUploadRequest(httpRequest)) {
            this.fileDataList = (List)httpRequest.getSession().getAttribute(IMIXS_FILEDATA_LIST);
            if (this.fileDataList == null) {
                this.fileDataList = new ArrayList<FileData>();
            }
            logger.fine("[MultipartRequestFilter] add files...");
            this.addFiles(httpRequest);
            httpRequest.getSession().setAttribute(IMIXS_FILEDATA_LIST, this.fileDataList);
            String contextURL = httpRequest.getRequestURI();
            this.writeJsonContent(contextURL, (ServletResponse)response);
        }
    }

    protected void doDelete(HttpServletRequest httpRequest, HttpServletResponse response) throws ServletException, IOException {
        this.fileDataList = (List)httpRequest.getSession().getAttribute(IMIXS_FILEDATA_LIST);
        if (this.fileDataList == null) {
            this.fileDataList = new ArrayList<FileData>();
        }
        int iCancel = httpRequest.getRequestURI().indexOf("/fileupload/");
        String filename = httpRequest.getRequestURI().substring(iCancel + 12);
        this.removeFile(filename);
        httpRequest.getSession().setAttribute(IMIXS_FILEDATA_LIST, this.fileDataList);
        String contextURL = httpRequest.getRequestURI();
        contextURL = contextURL.substring(0, contextURL.lastIndexOf(47) + 1);
        this.writeJsonContent(contextURL, (ServletResponse)response);
    }

    protected void doGet(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException, IOException {
        this.fileDataList = (List)httpRequest.getSession().getAttribute(IMIXS_FILEDATA_LIST);
        if (this.fileDataList == null) {
            this.fileDataList = new ArrayList<FileData>();
        }
        if (this.isGetFileUploadRequest(httpRequest)) {
            int iCancel = httpRequest.getRequestURI().indexOf("/fileupload/");
            String filename = httpRequest.getRequestURI().substring(iCancel + 12);
            FileData fileData = this.getFile(filename);
            if (fileData != null) {
                this.writeFileContent((ServletResponse)httpResponse, fileData);
            } else {
                httpResponse.sendError(404);
            }
        }
        if (this.isGetRefreshFileUploadRequest(httpRequest)) {
            String contextURL = httpRequest.getRequestURI();
            this.writeJsonContent(contextURL, (ServletResponse)httpResponse);
        }
    }

    private boolean isPostFileUploadRequest(HttpServletRequest httpRequest) {
        String sContentType = httpRequest.getContentType();
        logger.fine("[MulitpartRequestFilter]  contentType=" + sContentType);
        return REQUEST_METHOD_POST.equalsIgnoreCase(httpRequest.getMethod()) && httpRequest.getContentType() != null && sContentType.toLowerCase().startsWith(CONTENT_TYPE_MULTIPART);
    }

    private boolean isGetFileUploadRequest(HttpServletRequest httpRequest) {
        String uri = httpRequest.getRequestURI();
        return REQUEST_METHOD_GET.equalsIgnoreCase(httpRequest.getMethod()) && !uri.endsWith("/fileupload") && !uri.endsWith("/fileupload/");
    }

    private boolean isGetRefreshFileUploadRequest(HttpServletRequest httpRequest) {
        String uri = httpRequest.getRequestURI();
        return REQUEST_METHOD_GET.equalsIgnoreCase(httpRequest.getMethod()) && (uri.endsWith("/fileupload") || uri.endsWith("/fileupload/"));
    }

    private void writeFileContent(ServletResponse response, FileData fileData) throws IOException {
        logger.fine("[MulitpartRequestFilter] write file content...");
        ServletOutputStream output = response.getOutputStream();
        output.write(fileData.getData());
        response.setContentType(fileData.getContentType());
        output.close();
    }

    private void writeJsonContent(String context_url, ServletResponse response) throws IOException {
        logger.fine("[MulitpartRequestFilter] return JSON content...");
        response.setContentType("application/json;charset=UTF-8");
        PrintWriter out = response.getWriter();
        out.write(this.getJson(context_url));
        out.close();
    }

    private String getFilename(Part part) {
        for (String cd : part.getHeader(CONTENT_DISPOSITION).split(";")) {
            if (!cd.trim().startsWith(CONTENT_DISPOSITION_FILENAME)) continue;
            return cd.substring(cd.indexOf(61) + 1).trim().replace("\"", "");
        }
        return null;
    }

    private void removeFile(String file) {
        int pos = -1;
        if (file == null) {
            return;
        }
        for (int i = 0; i < this.fileDataList.size(); ++i) {
            FileData fileData = this.fileDataList.get(i);
            if (!file.equals(fileData.getName())) continue;
            pos = i;
            break;
        }
        if (pos > -1) {
            logger.fine("[MultipartRequestWrapper] remove file '" + file + "'");
            this.fileDataList.remove(pos);
        }
    }

    private void addFiles(HttpServletRequest httpRequest) {
        logger.fine("[MultipartRequestWrapper] Looping parts");
        try {
            for (Part p : httpRequest.getParts()) {
                byte[] b = new byte[(int)p.getSize()];
                p.getInputStream().read(b);
                p.getInputStream().close();
                String fileName = this.getFilename(p);
                if (fileName == null) continue;
                FileData fileData = null;
                logger.fine("Filename : " + fileName + ", contentType " + p.getContentType());
                fileData = new FileData(fileName, p.getContentType(), b);
                if (fileData == null) continue;
                this.removeFile(fileData.getName());
                this.fileDataList.add(fileData);
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        catch (ServletException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    private FileData getFile(String file) {
        FileData result = null;
        if (file == null) {
            return null;
        }
        for (int i = 0; i < this.fileDataList.size(); ++i) {
            FileData fileData = this.fileDataList.get(i);
            if (!file.equals(fileData.getName())) continue;
            result = fileData;
            break;
        }
        return result;
    }

    private String getJson(String context_url) {
        String result = "{ \"files\":[";
        for (int i = 0; i < this.fileDataList.size(); ++i) {
            FileData fileData = this.fileDataList.get(i);
            result = result + "{ \"url\": \"" + context_url + fileData.getName() + "\",";
            result = result + "\"thumbnail_url\": \"\",";
            result = result + "\"name\": \"" + fileData.getName() + "\",";
            result = result + "\"type\": \"" + fileData.getContentType() + "\",";
            result = result + "\"size\": " + fileData.getSize() + ",";
            result = result + "\"delete_url\": \"\",";
            result = result + "\"delete_type\": \"DELETE\"";
            result = i < this.fileDataList.size() - 1 ? result + "}," : result + "}";
        }
        result = result + "]}";
        return result;
    }
}

