/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jee.faces.workitem;

import java.util.List;
import javax.ejb.EJB;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.jee.ejb.WorkflowService;
import org.imixs.workflow.jee.faces.workitem.ViewController;

public class WorklistController
extends ViewController {
    private static final long serialVersionUID = 1L;
    private int sortOrder;
    public static final String QUERY_WORKLIST_BY_OWNER = "worklist.owner";
    public static final String QUERY_WORKLIST_BY_CREATOR = "worklist.creator";
    public static final String QUERY_WORKLIST_BY_AUTHOR = "worklist.author";
    public static final String QUERY_WORKLIST_BY_WRITEACCESS = "worklist.writeaccess";
    public static final String QUERY_WORKLIST_ALL = "worklist.all";
    @EJB
    private WorkflowService workflowService;

    public WorklistController() {
        this.setType("workitem");
        this.setView(QUERY_WORKLIST_ALL);
        this.setSortOrder(0);
        this.setViewAdapter(new WorkflowViewAdapter());
    }

    public WorkflowService getWorkflowService() {
        return this.workflowService;
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(int sortOrder) {
        this.sortOrder = sortOrder;
    }

    class WorkflowViewAdapter
    extends ViewController.ViewAdapter {
        WorkflowViewAdapter() {
        }

        @Override
        public List<ItemCollection> getViewEntries(ViewController controller) {
            if (WorklistController.QUERY_WORKLIST_BY_AUTHOR.equals(WorklistController.this.getView())) {
                return WorklistController.this.workflowService.getWorkListByAuthor(null, controller.getRow(), controller.getMaxResult(), controller.getType(), WorklistController.this.getSortOrder());
            }
            if (WorklistController.QUERY_WORKLIST_BY_CREATOR.equals(WorklistController.this.getView())) {
                return WorklistController.this.workflowService.getWorkListByCreator(null, controller.getRow(), controller.getMaxResult(), controller.getType(), WorklistController.this.getSortOrder());
            }
            if (WorklistController.QUERY_WORKLIST_BY_OWNER.equals(WorklistController.this.getView())) {
                return WorklistController.this.workflowService.getWorkListByOwner(null, controller.getRow(), controller.getMaxResult(), controller.getType(), WorklistController.this.getSortOrder());
            }
            if (WorklistController.QUERY_WORKLIST_BY_WRITEACCESS.equals(WorklistController.this.getView())) {
                return WorklistController.this.workflowService.getWorkListByWriteAccess(controller.getRow(), controller.getMaxResult(), controller.getType(), WorklistController.this.getSortOrder());
            }
            if (WorklistController.QUERY_WORKLIST_ALL.equals(WorklistController.this.getView())) {
                return WorklistController.this.workflowService.getWorkList(controller.getRow(), controller.getMaxResult(), controller.getType(), WorklistController.this.getSortOrder());
            }
            return super.getViewEntries(controller);
        }
    }
}

