/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.faces.workitem;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.ejb.EJB;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.InvalidAccessException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.faces.workitem.DocumentController;

public class WorkflowController
extends DocumentController {
    private static final long serialVersionUID = 1L;
    @EJB
    private ModelService modelService;
    @EJB
    private WorkflowService workflowService;
    private static Logger logger = Logger.getLogger(WorkflowController.class.getName());

    public ModelService getModelService() {
        return this.modelService;
    }

    public WorkflowService getWorkflowService() {
        return this.workflowService;
    }

    public String init(String action) throws ModelException {
        List col;
        if (this.workitem == null) {
            return action;
        }
        ItemCollection startProcessEntity = null;
        if (this.workitem.getItemValueInteger("$processid") <= 0 && !(col = this.modelService.getModelByWorkitem(this.getWorkitem()).findAllTasks()).isEmpty()) {
            startProcessEntity = (ItemCollection)col.iterator().next();
            this.getWorkitem().replaceItemValue("$processid", (Object)startProcessEntity.getItemValueInteger("numProcessID"));
        }
        if ((startProcessEntity = this.modelService.getModelByWorkitem(this.workitem).getTask(this.workitem.getItemValueInteger("$processid"))) == null) {
            throw new InvalidAccessException("INVALID_MODEL_ENTRY", "unable to find ProcessEntity in model version " + this.workitem.getItemValueString("$modelversion") + " for ID=" + this.workitem.getItemValueInteger("$processid"));
        }
        this.workitem.replaceItemValue("$WriteAccess", (Object)this.workitem.getItemValue("namCreator"));
        this.workitem.replaceItemValue("txtworkflowgroup", (Object)startProcessEntity.getItemValueString("txtworkflowgroup"));
        this.workitem.replaceItemValue("txtworkflowStatus", (Object)startProcessEntity.getItemValueString("txtname"));
        this.workitem.replaceItemValue("txtWorkflowImageURL", (Object)startProcessEntity.getItemValueString("txtimageurl"));
        this.workitem.replaceItemValue("txtWorkflowEditorid", (Object)startProcessEntity.getItemValueString("txteditorid"));
        return action;
    }

    public String process() throws AccessDeniedException, ProcessingErrorException, PluginException {
        if (this.workitem == null) {
            logger.warning("Unable to process workitem == null!");
            return null;
        }
        this.workitem.replaceItemValue("action", (Object)"");
        this.workitem = this.getWorkflowService().processWorkItem(this.workitem);
        String action = this.workitem.getItemValueString("action");
        if ("".equals(action)) {
            action = this.workitem.getItemValueString("txtworkflowresultmessage");
        }
        return "".equals(action) ? null : action;
    }

    public String process(int id, boolean resetWorkitem) throws AccessDeniedException, ProcessingErrorException, PluginException {
        this.getWorkitem().replaceItemValue("$ActivityID", (Object)id);
        String result = this.process();
        return result;
    }

    public String process(int id) throws AccessDeniedException, ProcessingErrorException, PluginException {
        return this.process(id, false);
    }

    public List<ItemCollection> getEvents() {
        List<Object> activityList = new ArrayList<ItemCollection>();
        if (this.getWorkitem() == null) {
            return activityList;
        }
        try {
            activityList = this.getWorkflowService().getEvents(this.getWorkitem());
        }
        catch (ModelException e) {
            logger.warning("Unable to get workflow event list: " + e.getMessage());
        }
        return activityList;
    }
}

