/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.faces.workitem;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.faces.event.ActionEvent;
import javax.faces.event.AjaxBehaviorEvent;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.exceptions.QueryException;

public class ViewController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String type = null;
    private String query = null;
    private String sortBy = null;
    private boolean sortReverse = false;
    private int pageSize = 10;
    private int pageIndex = 0;
    private boolean endOfList = false;
    private List<ItemCollection> workitems = null;
    @EJB
    DocumentService documentService;

    @PostConstruct
    public void init() {
        if (this.type == null || this.type.isEmpty()) {
            this.setType("workitem");
        }
        if (this.query == null || this.query.isEmpty()) {
            this.setQuery("(type:\"" + this.getType() + "\")");
        }
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public boolean isSortReverse() {
        return this.sortReverse;
    }

    public void setSortReverse(boolean sortReverse) {
        this.sortReverse = sortReverse;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void doReset() {
        this.workitems = null;
        this.pageIndex = 0;
    }

    public void doReset(ActionEvent event) {
        this.doReset();
    }

    public void doReset(AjaxBehaviorEvent event) {
        this.doReset();
    }

    public void doRefresh() {
        this.workitems = null;
    }

    public void doRefresh(ActionEvent event) {
        this.doRefresh();
    }

    public void doRefresh(AjaxBehaviorEvent event) {
        this.doRefresh();
    }

    public void doLoadNext() {
        ++this.pageIndex;
        this.workitems = null;
    }

    public void doLoadNext(ActionEvent event) {
        this.doLoadNext();
    }

    public void doLoadNext(AjaxBehaviorEvent event) {
        this.doLoadNext();
    }

    public void doLoadPrev() {
        --this.pageIndex;
        this.pageIndex = 0;
        this.workitems = null;
    }

    public void doLoadPrev(ActionEvent event) {
        this.doLoadPrev();
    }

    public void doLoadPrev(AjaxBehaviorEvent event) {
        this.doLoadPrev();
    }

    public List<ItemCollection> getWorkitems() throws QueryException {
        if (this.workitems != null) {
            return this.workitems;
        }
        this.workitems = new ArrayList<ItemCollection>();
        String _query = this.getQuery();
        if (_query == null || _query.isEmpty()) {
            return this.workitems;
        }
        this.workitems = this.getDocumentService().find(_query, this.getPageSize(), this.getPageIndex(), this.getSortBy(), this.isSortReverse());
        if (this.workitems == null) {
            this.workitems = new ArrayList<ItemCollection>();
        }
        this.endOfList = this.workitems.size() < this.pageSize;
        return this.workitems;
    }

    public void setWorkitems(List<ItemCollection> workitems) {
        this.workitems = workitems;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    public boolean isEndOfList() {
        return this.endOfList;
    }

    public void setEndOfList(boolean endOfList) {
        this.endOfList = endOfList;
    }
}

