/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.faces.workitem;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.faces.application.FacesMessage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.exceptions.AccessDeniedException;

public class DocumentController
implements Serializable {
    private static final long serialVersionUID = 1L;
    ItemCollection workitem = null;
    private String defaultType;
    @EJB
    DocumentService documentService;
    private static Logger logger = Logger.getLogger("org.imixs.workflow");

    public DocumentController() {
        this.setDefaultType("workitem");
    }

    public String getDefaultType() {
        return this.defaultType;
    }

    public void setDefaultType(String type) {
        this.defaultType = type;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public ItemCollection getWorkitem() {
        if (this.workitem == null) {
            this.workitem = new ItemCollection();
            this.workitem.replaceItemValue("type", (Object)this.getDefaultType());
            this.setWorkitem(this.workitem);
        }
        return this.workitem;
    }

    public void setWorkitem(ItemCollection workitem) {
        this.workitem = workitem;
    }

    public void create() {
        this.reset();
        this.getWorkitem();
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext externalContext = context.getExternalContext();
        String sUser = externalContext.getRemoteUser();
        this.workitem.replaceItemValue("namCreator", (Object)sUser);
        logger.fine("ItemCollection created");
    }

    public void create(ActionEvent event) {
        this.create();
    }

    public void save() throws AccessDeniedException {
        this.workitem = this.getDocumentService().save(this.workitem);
        logger.fine("ItemCollection saved");
    }

    public String save(String action) throws AccessDeniedException {
        this.save();
        return action;
    }

    public void reset() {
        this.workitem = null;
    }

    public void load(String uniqueID) {
        this.reset();
        this.setWorkitem(this.getDocumentService().load(uniqueID));
        if (this.workitem != null) {
            logger.fine("workitem '" + uniqueID + "' loaded");
        } else {
            logger.fine("workitem '" + uniqueID + "' not found (null)");
        }
    }

    public String load(String uniqueID, String action) {
        this.load(uniqueID);
        return action;
    }

    public void delete(String uniqueID) throws AccessDeniedException {
        ItemCollection _workitem = this.getDocumentService().load(uniqueID);
        if (_workitem != null) {
            this.documentService.remove(_workitem);
            this.setWorkitem(null);
            logger.fine("workitem " + uniqueID + " deleted");
        } else {
            logger.fine("workitem '" + uniqueID + "' not found (null)");
        }
    }

    public String delete(String uniqueID, String action) throws AccessDeniedException {
        this.delete(uniqueID);
        return action;
    }

    public boolean isNewWorkitem() {
        Date created = this.getWorkitem().getItemValueDate("$created");
        Date modified = this.getWorkitem().getItemValueDate("$modified");
        return modified == null || created == null;
    }

    public void addMessage(String ressourceBundleName, String messageKey, Object param) {
        String msgPattern;
        FacesContext context = FacesContext.getCurrentInstance();
        Locale locale = context.getViewRoot().getLocale();
        ResourceBundle rb = ResourceBundle.getBundle(ressourceBundleName, locale);
        String msg = msgPattern = rb.getString(messageKey);
        if (param != null) {
            Object[] params = new Object[]{param};
            msg = MessageFormat.format(msgPattern, params);
        }
        FacesMessage facesMsg = new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, msg);
        context.addMessage(null, facesMsg);
    }
}

