/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.faces.fileupload;

import java.io.Serializable;
import java.util.List;
import java.util.logging.Logger;
import javax.enterprise.context.SessionScoped;
import javax.faces.context.FacesContext;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.faces.fileupload.FileData;

@Named
@SessionScoped
public class FileUploadController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(FileUploadController.class.getName());

    public void updateWorkitem(ItemCollection workitem) {
        if (workitem == null) {
            return;
        }
        logger.fine("[MultiFileController] updateWorkitem '" + workitem.getItemValueString("$uniqueid"));
        HttpServletRequest httpRequest = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
        List fileDataList = (List)httpRequest.getSession().getAttribute("IMIXS_FILEDATA_LIST");
        if (fileDataList == null) {
            return;
        }
        for (FileData aFile : fileDataList) {
            workitem.addFile(aFile.getData(), aFile.getName(), aFile.getContentType());
        }
        this.reset();
    }

    public void removeAttachedFile(ItemCollection workitem, String aFilename) {
        workitem.removeFile(aFilename);
    }

    public List<FileData> getUploades() {
        HttpServletRequest httpRequest = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
        List fileDataList = (List)httpRequest.getSession().getAttribute("IMIXS_FILEDATA_LIST");
        return fileDataList;
    }

    public void reset() {
        HttpServletRequest httpRequest = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
        httpRequest.getSession().removeAttribute("IMIXS_FILEDATA_LIST");
    }
}

