/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.faces.fileupload;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.imixs.workflow.faces.fileupload.FileData;

@WebServlet(urlPatterns={"/fileupload/*"})
@MultipartConfig(fileSizeThreshold=0x100000, maxFileSize=0x6400000L, maxRequestSize=524288000L)
public class AjaxFileUploadServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String REQUEST_METHOD_POST = "POST";
    private static final String REQUEST_METHOD_GET = "GET";
    private static final String CONTENT_TYPE_MULTIPART = "multipart/";
    private static final String CONTENT_DISPOSITION = "content-disposition";
    private static final String CONTENT_DISPOSITION_FILENAME = "filename";
    public static final String IMIXS_FILEDATA_LIST = "IMIXS_FILEDATA_LIST";
    private static Logger logger = Logger.getLogger(AjaxFileUploadServlet.class.getName());

    private List<FileData> getFileList(HttpServletRequest httpRequest) {
        ArrayList fileDataList = (ArrayList)httpRequest.getSession().getAttribute(IMIXS_FILEDATA_LIST);
        if (fileDataList == null) {
            fileDataList = new ArrayList();
            httpRequest.getSession().setAttribute(IMIXS_FILEDATA_LIST, fileDataList);
        }
        return fileDataList;
    }

    private void setFileList(HttpServletRequest httpRequest, List<FileData> fileDataList) {
        if (fileDataList == null) {
            fileDataList = new ArrayList<FileData>();
        }
        httpRequest.getSession().setAttribute(IMIXS_FILEDATA_LIST, fileDataList);
    }

    protected void doPost(HttpServletRequest httpRequest, HttpServletResponse response) throws ServletException, IOException {
        if (this.isPostFileUploadRequest(httpRequest)) {
            List<FileData> fileDataList = this.getFileList(httpRequest);
            logger.fine("[MultipartRequestFilter] add files...");
            this.addFiles(httpRequest);
            this.setFileList(httpRequest, fileDataList);
            String contextURL = httpRequest.getRequestURI();
            this.writeJsonContent(httpRequest, (ServletResponse)response, contextURL);
        }
    }

    protected void doDelete(HttpServletRequest httpRequest, HttpServletResponse response) throws ServletException, IOException {
        List<FileData> fileDataList = this.getFileList(httpRequest);
        int iCancel = httpRequest.getRequestURI().indexOf("/fileupload/");
        String filename = httpRequest.getRequestURI().substring(iCancel + 12);
        this.removeFile(httpRequest, filename);
        this.setFileList(httpRequest, fileDataList);
        String contextURL = httpRequest.getRequestURI();
        contextURL = contextURL.substring(0, contextURL.lastIndexOf(47) + 1);
        this.writeJsonContent(httpRequest, (ServletResponse)response, contextURL);
    }

    protected void doGet(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException, IOException {
        if (this.isGetFileUploadRequest(httpRequest)) {
            int iCancel = httpRequest.getRequestURI().indexOf("/fileupload/");
            String filename = httpRequest.getRequestURI().substring(iCancel + 12);
            FileData fileData = this.getFile(httpRequest, filename = URLDecoder.decode(filename, "UTF-8"));
            if (fileData != null) {
                this.writeFileContent((ServletResponse)httpResponse, fileData);
            } else {
                httpResponse.sendError(404);
            }
        }
        if (this.isGetRefreshFileUploadRequest(httpRequest)) {
            String contextURL = httpRequest.getRequestURI();
            this.writeJsonContent(httpRequest, (ServletResponse)httpResponse, contextURL);
        }
    }

    private boolean isPostFileUploadRequest(HttpServletRequest httpRequest) {
        String sContentType = httpRequest.getContentType();
        logger.fine("[MulitpartRequestFilter]  contentType=" + sContentType);
        return REQUEST_METHOD_POST.equalsIgnoreCase(httpRequest.getMethod()) && httpRequest.getContentType() != null && sContentType.toLowerCase().startsWith(CONTENT_TYPE_MULTIPART);
    }

    private boolean isGetFileUploadRequest(HttpServletRequest httpRequest) {
        String uri = httpRequest.getRequestURI();
        return REQUEST_METHOD_GET.equalsIgnoreCase(httpRequest.getMethod()) && !uri.endsWith("/fileupload") && !uri.endsWith("/fileupload/");
    }

    private boolean isGetRefreshFileUploadRequest(HttpServletRequest httpRequest) {
        String uri = httpRequest.getRequestURI();
        return REQUEST_METHOD_GET.equalsIgnoreCase(httpRequest.getMethod()) && (uri.endsWith("/fileupload") || uri.endsWith("/fileupload/"));
    }

    private void writeFileContent(ServletResponse response, FileData fileData) throws IOException {
        logger.fine("[MulitpartRequestFilter] write file content...");
        ServletOutputStream output = response.getOutputStream();
        output.write(fileData.getData());
        response.setContentType(fileData.getContentType());
        output.close();
    }

    private void writeJsonContent(HttpServletRequest httpRequest, ServletResponse response, String context_url) throws IOException {
        logger.fine("[MulitpartRequestFilter] return JSON content...");
        response.setContentType("application/json;charset=UTF-8");
        PrintWriter out = response.getWriter();
        out.write(this.getJson(httpRequest, context_url));
        out.close();
    }

    private String getFilename(Part part) {
        for (String cd : part.getHeader(CONTENT_DISPOSITION).split(";")) {
            if (!cd.trim().startsWith(CONTENT_DISPOSITION_FILENAME)) continue;
            return cd.substring(cd.indexOf(61) + 1).trim().replace("\"", "");
        }
        return null;
    }

    private List<FileData> removeFile(HttpServletRequest httpRequest, String file) {
        int pos = -1;
        List<FileData> fileDataList = this.getFileList(httpRequest);
        if (file == null) {
            return fileDataList;
        }
        for (int i = 0; i < fileDataList.size(); ++i) {
            FileData fileData = fileDataList.get(i);
            if (!file.equals(fileData.getName())) continue;
            pos = i;
            break;
        }
        if (pos > -1) {
            logger.fine("[MultipartRequestWrapper] remove file '" + file + "'");
            fileDataList.remove(pos);
            this.setFileList(httpRequest, fileDataList);
        }
        return fileDataList;
    }

    private void addFiles(HttpServletRequest httpRequest) {
        logger.fine("[MultipartRequestWrapper] Looping parts");
        try {
            for (Part p : httpRequest.getParts()) {
                byte[] b = new byte[(int)p.getSize()];
                p.getInputStream().read(b);
                p.getInputStream().close();
                String fileName = this.getFilename(p);
                if (fileName == null) continue;
                byte[] fileNameISOBytes = fileName.getBytes("iso-8859-1");
                String fileNameUTF8 = new String(fileNameISOBytes, "UTF-8");
                if (fileName.length() != fileNameUTF8.length()) {
                    logger.fine("filename seems to be ISO-8859-1 encoded");
                    fileName = new String(fileName.getBytes("iso-8859-1"), "utf-8");
                }
                FileData fileData = null;
                logger.fine("Filename : " + fileName + ", contentType " + p.getContentType());
                fileData = new FileData(fileName, p.getContentType(), b);
                if (fileData == null) continue;
                List<FileData> fileDataList = this.removeFile(httpRequest, fileData.getName());
                fileDataList.add(fileData);
                this.setFileList(httpRequest, fileDataList);
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        catch (ServletException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    private FileData getFile(HttpServletRequest httpRequest, String file) {
        List<FileData> fileDataList = this.getFileList(httpRequest);
        FileData result = null;
        if (file == null) {
            return null;
        }
        for (int i = 0; i < fileDataList.size(); ++i) {
            FileData fileData = fileDataList.get(i);
            if (!file.equals(fileData.getName())) continue;
            result = fileData;
            break;
        }
        return result;
    }

    private String getJson(HttpServletRequest httpRequest, String context_url) {
        List<FileData> fileDataList = this.getFileList(httpRequest);
        String result = "{ \"files\":[";
        for (int i = 0; i < fileDataList.size(); ++i) {
            FileData fileData = fileDataList.get(i);
            result = result + "{ \"url\": \"" + context_url + fileData.getName() + "\",";
            result = result + "\"thumbnail_url\": \"\",";
            result = result + "\"name\": \"" + fileData.getName() + "\",";
            result = result + "\"type\": \"" + fileData.getContentType() + "\",";
            result = result + "\"size\": " + fileData.getSize() + ",";
            result = result + "\"delete_url\": \"\",";
            result = result + "\"delete_type\": \"DELETE\"";
            result = i < fileDataList.size() - 1 ? result + "}," : result + "}";
        }
        result = result + "]}";
        return result;
    }
}

