/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.faces.fileupload;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.imixs.workflow.FileData;
import org.imixs.workflow.faces.fileupload.FileUploadController;

@WebServlet(urlPatterns={"/fileupload/*"})
@MultipartConfig(fileSizeThreshold=0x100000, maxFileSize=0x6400000L, maxRequestSize=524288000L)
public class AjaxFileUploadServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String REQUEST_METHOD_POST = "POST";
    private static final String REQUEST_METHOD_GET = "GET";
    private static final String CONTENT_TYPE_MULTIPART = "multipart/";
    private static final String CONTENT_DISPOSITION = "content-disposition";
    private static final String CONTENT_DISPOSITION_FILENAME = "filename";
    public static final String IMIXS_FILEDATA_LIST = "IMIXS_FILEDATA_LIST";
    private static Logger logger = Logger.getLogger(AjaxFileUploadServlet.class.getName());
    @Inject
    FileUploadController fileUploadController;

    protected void doPost(HttpServletRequest httpRequest, HttpServletResponse response) throws ServletException, IOException {
        if (this.isPostFileUploadRequest(httpRequest)) {
            logger.finest("......add files...");
            List<FileData> fileDataList = this.getFilesFromRequest(httpRequest);
            if (this.fileUploadController != null && this.fileUploadController.getWorkitem() != null) {
                logger.finest("......add new fileData object...");
                for (FileData filedata : fileDataList) {
                    this.fileUploadController.addAttachedFile(filedata);
                }
            }
            this.writeJsonMetadata((ServletResponse)response, httpRequest.getRequestURI());
        }
    }

    protected void doDelete(HttpServletRequest httpRequest, HttpServletResponse response) throws ServletException, IOException {
        int iCancel = httpRequest.getRequestURI().indexOf("/fileupload/");
        String filename = httpRequest.getRequestURI().substring(iCancel + 12);
        if (this.fileUploadController != null) {
            this.fileUploadController.removeAttachedFile(filename);
        }
        String contextURL = httpRequest.getRequestURI();
        contextURL = contextURL.substring(0, contextURL.lastIndexOf(47) + 1);
        this.writeJsonMetadata((ServletResponse)response, contextURL);
    }

    protected void doGet(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException, IOException {
        if (this.isGetFileUploadRequest(httpRequest)) {
            int iCancel = httpRequest.getRequestURI().indexOf("/fileupload/");
            String filename = httpRequest.getRequestURI().substring(iCancel + 12);
            filename = URLDecoder.decode(filename, "UTF-8");
            if (this.fileUploadController != null && this.fileUploadController.getWorkitem() != null) {
                FileData fileData = this.fileUploadController.getWorkitem().getFileData(filename);
                if (fileData != null) {
                    this.writeFileContent((ServletResponse)httpResponse, fileData);
                } else {
                    httpResponse.sendError(404);
                }
            }
        }
        if (this.isGetRefreshFileUploadRequest(httpRequest)) {
            String contextURL = httpRequest.getRequestURI();
            this.writeJsonMetadata((ServletResponse)httpResponse, contextURL);
        }
    }

    private boolean isPostFileUploadRequest(HttpServletRequest httpRequest) {
        String sContentType = httpRequest.getContentType();
        logger.finest("......contentType=" + sContentType);
        return REQUEST_METHOD_POST.equalsIgnoreCase(httpRequest.getMethod()) && httpRequest.getContentType() != null && sContentType.toLowerCase().startsWith(CONTENT_TYPE_MULTIPART);
    }

    private boolean isGetFileUploadRequest(HttpServletRequest httpRequest) {
        String uri = httpRequest.getRequestURI();
        return REQUEST_METHOD_GET.equalsIgnoreCase(httpRequest.getMethod()) && !uri.endsWith("/fileupload") && !uri.endsWith("/fileupload/");
    }

    private boolean isGetRefreshFileUploadRequest(HttpServletRequest httpRequest) {
        String uri = httpRequest.getRequestURI();
        return REQUEST_METHOD_GET.equalsIgnoreCase(httpRequest.getMethod()) && (uri.endsWith("/fileupload") || uri.endsWith("/fileupload/"));
    }

    private void writeFileContent(ServletResponse response, FileData fileData) throws IOException {
        logger.finest("......write file content...");
        ServletOutputStream output = response.getOutputStream();
        output.write(fileData.getContent());
        response.setContentType(fileData.getContentType());
        output.close();
    }

    private String getFilename(Part part) {
        for (String cd : part.getHeader(CONTENT_DISPOSITION).split(";")) {
            if (!cd.trim().startsWith(CONTENT_DISPOSITION_FILENAME)) continue;
            return cd.substring(cd.indexOf(61) + 1).trim().replace("\"", "");
        }
        return null;
    }

    private List<FileData> getFilesFromRequest(HttpServletRequest httpRequest) {
        logger.finest("......Looping parts");
        ArrayList<FileData> fileDataList = new ArrayList<FileData>();
        try {
            for (Part p : httpRequest.getParts()) {
                byte[] b = new byte[(int)p.getSize()];
                p.getInputStream().read(b);
                p.getInputStream().close();
                String fileName = this.getFilename(p);
                if (fileName == null) continue;
                byte[] fileNameISOBytes = fileName.getBytes("iso-8859-1");
                String fileNameUTF8 = new String(fileNameISOBytes, "UTF-8");
                if (fileName.length() != fileNameUTF8.length()) {
                    logger.finest("......filename seems to be ISO-8859-1 encoded");
                    fileName = new String(fileName.getBytes("iso-8859-1"), "utf-8");
                }
                FileData fileData = null;
                logger.finest("......filename : " + fileName + ", contentType " + p.getContentType());
                fileData = new FileData(fileName, b, p.getContentType());
                fileDataList.add(fileData);
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        catch (ServletException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        return fileDataList;
    }

    private void writeJsonMetadata(ServletResponse response, String context_url) throws IOException {
        response.setContentType("application/json;charset=UTF-8");
        PrintWriter out = response.getWriter();
        if (this.fileUploadController != null && this.fileUploadController.getWorkitem() != null) {
            List<FileData> fileDataList = this.fileUploadController.getAttachedFiles();
            logger.finest("......write JSON meta data...");
            String result = "{ \"files\":[";
            for (int i = 0; i < fileDataList.size(); ++i) {
                FileData fileData = fileDataList.get(i);
                result = result + "{ \"url\": \"" + context_url + fileData.getName() + "?cid=" + this.fileUploadController.getCID() + "\",";
                result = result + "\"thumbnail_url\": \"\",";
                result = result + "\"name\": \"" + fileData.getName() + "\",";
                result = result + "\"type\": \"" + fileData.getContentType() + "\",";
                result = result + "\"size\": " + fileData.getContent().length + ",";
                result = result + "\"delete_url\": \"\",";
                result = result + "\"delete_type\": \"DELETE\"";
                result = i < fileDataList.size() - 1 ? result + "}," : result + "}";
            }
            result = result + "]}";
            out.write(result);
        }
        out.close();
    }
}

