/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.faces.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.ObserverException;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.InvalidAccessException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.WorkflowException;
import org.imixs.workflow.faces.data.AbstractDataController;
import org.imixs.workflow.faces.data.WorkflowEvent;
import org.imixs.workflow.faces.util.ErrorHandler;
import org.imixs.workflow.faces.util.LoginController;
import org.imixs.workflow.faces.util.ValidationException;

@Named
@ConversationScoped
public class WorkflowController
extends AbstractDataController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(WorkflowController.class.getName());
    @EJB
    ModelService modelService;
    @EJB
    WorkflowService workflowService;
    @Inject
    Event<WorkflowEvent> events;
    @Inject
    LoginController loginController;
    public static final String DEFAULT_TYPE = "workitem";

    public WorkflowController() {
        this.setDefaultType(DEFAULT_TYPE);
    }

    public ItemCollection getWorkitem() {
        if (this.data == null) {
            this.reset();
        }
        return this.data;
    }

    public void setWorkitem(ItemCollection workitem) {
        this.data = workitem;
    }

    public void create() throws ModelException {
        List col;
        if (this.data == null) {
            return;
        }
        ItemCollection startProcessEntity = null;
        if (this.data.getTaskID() <= 0 && !(col = this.modelService.getModelByWorkitem(this.getWorkitem()).findAllTasks()).isEmpty()) {
            startProcessEntity = (ItemCollection)col.iterator().next();
            this.getWorkitem().setTaskID(startProcessEntity.getItemValueInteger("numProcessID"));
        }
        if ((startProcessEntity = this.modelService.getModelByWorkitem(this.data).getTask(this.data.getTaskID())) == null) {
            throw new InvalidAccessException("INVALID_MODEL_ENTRY", "unable to find ProcessEntity in model version " + this.data.getModelVersion() + " for ID=" + this.data.getTaskID());
        }
        String type = startProcessEntity.getItemValueString("txttype");
        if (type.isEmpty()) {
            type = DEFAULT_TYPE;
        }
        this.data.replaceItemValue("type", (Object)type);
        this.data.replaceItemValue("$writeaccess", (Object)this.data.getItemValue("$creator"));
        this.data.replaceItemValue("$workflowgroup", (Object)startProcessEntity.getItemValueString("txtworkflowgroup"));
        this.data.replaceItemValue("$workflowStatus", (Object)startProcessEntity.getItemValueString("txtname"));
        this.data.replaceItemValue("txtWorkflowImageURL", (Object)startProcessEntity.getItemValueString("txtimageurl"));
        this.data.replaceItemValue("txtWorkflowEditorid", (Object)startProcessEntity.getItemValueString("txteditorid"));
        this.data.replaceItemValue("txtworkflowgroup", (Object)startProcessEntity.getItemValueString("txtworkflowgroup"));
        this.data.replaceItemValue("txtworkflowStatus", (Object)startProcessEntity.getItemValueString("txtname"));
        this.startConversation();
        this.events.fire((Object)new WorkflowEvent(this.getWorkitem(), 20));
    }

    public void create(String modelVersion, int taskID, String uniqueIdRef) throws ModelException {
        this.data = new ItemCollection();
        this.data.model(modelVersion).task(taskID);
        if (uniqueIdRef != null && !uniqueIdRef.isEmpty()) {
            this.data.replaceItemValue("$uniqueidref", (Object)uniqueIdRef);
        }
        this.data.replaceItemValue("namowner", (Object)this.loginController.getUserPrincipal());
        this.data.replaceItemValue("$workitemid", (Object)"");
        this.create();
    }

    public String process() throws PluginException, ModelException {
        String actionResult = null;
        long lTotal = System.currentTimeMillis();
        if (this.data == null) {
            logger.warning("Unable to process workitem == null!");
            return actionResult;
        }
        this.data.replaceItemValue("action", (Object)"");
        try {
            long l1 = System.currentTimeMillis();
            this.events.fire((Object)new WorkflowEvent(this.getWorkitem(), 22));
            logger.finest("......fire WORKITEM_BEFORE_PROCESS event: ' in " + (System.currentTimeMillis() - l1) + "ms");
            this.data = this.workflowService.processWorkItem(this.data);
            actionResult = this.data.getItemValueString("action");
            if (actionResult == null || actionResult.isEmpty()) {
                FacesContext facesContext = FacesContext.getCurrentInstance();
                actionResult = facesContext.getViewRoot().getViewId();
                actionResult = actionResult + "?id=" + this.getWorkitem().getUniqueID() + "&faces-redirect=true";
            }
            if (actionResult.contains("/") && !actionResult.contains("faces-redirect=")) {
                actionResult = !actionResult.contains("?") ? actionResult + "?faces-redirect=true" : actionResult + "&faces-redirect=true";
            }
            logger.fine("... new actionResult=" + actionResult);
            long l2 = System.currentTimeMillis();
            this.events.fire((Object)new WorkflowEvent(this.getWorkitem(), 23));
            logger.finest("......[process] fire WORKITEM_AFTER_PROCESS event: ' in " + (System.currentTimeMillis() - l2) + "ms");
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("......[process] '" + this.getWorkitem().getItemValueString("$uniqueid") + "' completed in " + (System.currentTimeMillis() - lTotal) + "ms");
            }
            this.close();
        }
        catch (ObserverException oe) {
            actionResult = null;
            if (oe.getCause() instanceof PluginException) {
                ErrorHandler.addErrorMessage((WorkflowException)((PluginException)oe.getCause()));
            }
            if (oe.getCause() instanceof ValidationException) {
                ErrorHandler.addErrorMessage((ValidationException)((Object)oe.getCause()));
            }
            throw oe;
        }
        catch (PluginException pe) {
            actionResult = null;
            ErrorHandler.handlePluginException(pe);
        }
        catch (ModelException me) {
            actionResult = null;
            ErrorHandler.handleModelException(me);
        }
        return actionResult;
    }

    public String process(int id) throws ModelException, PluginException {
        if (this.data == null) {
            logger.finest("......process workitem is null");
        } else {
            logger.finest("......process workitem id: " + this.data.getUniqueID());
        }
        this.getWorkitem().setEventID(id);
        return this.process();
    }

    public List<ItemCollection> getEvents() {
        List<Object> activityList = new ArrayList<ItemCollection>();
        if (this.getWorkitem() == null || this.getWorkitem().getModelVersion().isEmpty() && this.getWorkitem().getItemValueString("$workflowgroup").isEmpty()) {
            return activityList;
        }
        try {
            activityList = this.workflowService.getEvents(this.getWorkitem());
        }
        catch (ModelException e) {
            logger.warning("Unable to get workflow event list: " + e.getMessage());
        }
        return activityList;
    }

    @Override
    public void load(String uniqueid) {
        super.load(uniqueid);
        if (this.data != null) {
            this.events.fire((Object)new WorkflowEvent(this.data, 21));
        }
    }
}

