/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.faces.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.faces.view.ViewScoped;
import javax.inject.Named;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.exceptions.QueryException;

@Named
@ViewScoped
public class ViewController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String query = null;
    private String sortBy = null;
    private boolean sortReverse = false;
    private int pageSize = 10;
    private int pageIndex = 0;
    private boolean endOfList = false;
    private boolean loadStubs = true;
    private static Logger logger = Logger.getLogger(ViewController.class.getName());
    @EJB
    DocumentService documentService;

    public ViewController() {
        logger.finest("...construct...");
    }

    @PostConstruct
    public void init() {
        logger.finest("init...");
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public boolean isSortReverse() {
        return this.sortReverse;
    }

    public void setSortReverse(boolean sortReverse) {
        this.sortReverse = sortReverse;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public boolean isLoadStubs() {
        return this.loadStubs;
    }

    public void setLoadStubs(boolean loadStubs) {
        this.loadStubs = loadStubs;
    }

    public void reset() {
        this.pageIndex = 0;
    }

    @Deprecated
    public List<ItemCollection> getWorkitems() throws QueryException {
        logger.warning("getWorkitems is deprected - replace with viewHandler#getData(viewController)");
        return null;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    public boolean isEndOfList() {
        return this.endOfList;
    }

    public void setEndOfList(boolean endOfList) {
        this.endOfList = endOfList;
    }

    public List<ItemCollection> loadData() throws QueryException {
        if (this.getQuery() == null || this.getQuery().isEmpty()) {
            logger.warning("no query defined!");
            return new ArrayList<ItemCollection>();
        }
        logger.finest("...... load data - query=" + this.getQuery() + " pageIndex=" + this.getPageIndex());
        List result = null;
        result = this.isLoadStubs() ? this.documentService.findStubs(this.getQuery(), this.getPageSize(), this.getPageIndex(), this.getSortBy(), this.isSortReverse()) : this.documentService.find(this.getQuery(), this.getPageSize(), this.getPageIndex(), this.getSortBy(), this.isSortReverse());
        if (result.size() < this.getPageSize()) {
            this.setEndOfList(true);
        } else {
            int iAhead = this.getPageSize() * (this.getPageIndex() + 1) + 1;
            if (this.documentService.count(this.getQuery(), iAhead) < iAhead) {
                this.setEndOfList(true);
            } else {
                this.setEndOfList(false);
            }
        }
        return result;
    }
}

