/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.faces.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.enterprise.context.RequestScoped;
import javax.inject.Named;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.exceptions.QueryException;
import org.imixs.workflow.faces.data.ViewController;

@Named
@RequestScoped
public class ViewHandler
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<Integer, List<ItemCollection>> data = null;
    private static Logger logger = Logger.getLogger(ViewHandler.class.getName());
    @EJB
    DocumentService documentService;

    @PostConstruct
    public void init() {
        logger.finest("......init data map");
        this.data = new HashMap<Integer, List<ItemCollection>>();
    }

    public void onLoad(ViewController viewController) throws QueryException {
        this.getData(viewController);
    }

    public void forward(ViewController viewController) {
        this.data.remove(this.getHashKey(viewController));
        viewController.setPageIndex(viewController.getPageIndex() + 1);
    }

    public void back(ViewController viewController) {
        this.data.remove(this.getHashKey(viewController));
        int i = viewController.getPageIndex();
        if (--i < 0) {
            i = 0;
        }
        viewController.setPageIndex(i);
    }

    public List<ItemCollection> getData(ViewController viewController) throws QueryException {
        if (viewController == null) {
            return new ArrayList<ItemCollection>();
        }
        if (viewController.getQuery() == null || viewController.getQuery().isEmpty()) {
            logger.finest("......ViewController - now query defined!");
            return new ArrayList<ItemCollection>();
        }
        List<ItemCollection> result = this.data.get(this.getHashKey(viewController));
        if (result != null) {
            return result;
        }
        result = viewController.loadData();
        logger.finest("......cache with hash=" + this.getHashKey(viewController));
        this.data.put(this.getHashKey(viewController), result);
        return result;
    }

    private int getHashKey(ViewController viewController) {
        if (viewController == null) {
            return -1;
        }
        String h = viewController.getQuery() + viewController.getPageIndex() + viewController.getPageSize();
        return h.hashCode();
    }
}

