/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.faces.data;

import java.io.Serializable;
import java.util.logging.Logger;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.event.Event;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.faces.data.AbstractDataController;
import org.imixs.workflow.faces.data.WorkflowEvent;

@Named
@ConversationScoped
public class DocumentController
extends AbstractDataController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(DocumentController.class.getName());
    @Inject
    protected Event<WorkflowEvent> events;
    @Inject
    private DocumentService documentService;

    public DocumentController() {
        this.setDefaultType("workitem");
    }

    public ItemCollection getDocument() {
        if (this.data == null) {
            this.reset();
        }
        return this.data;
    }

    public void setDocument(ItemCollection document) {
        this.data = document;
        if (this.events != null) {
            this.events.fire((Object)new WorkflowEvent(this.data, 3));
        } else {
            logger.warning("Missing CDI support for Event<WorkflowEvent> !");
        }
    }

    public void create() {
        this.reset();
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext externalContext = context.getExternalContext();
        String sUser = externalContext.getRemoteUser();
        this.data.replaceItemValue("$Creator", (Object)sUser);
        this.data.replaceItemValue("namCreator", (Object)sUser);
        this.startConversation();
        if (this.events != null) {
            this.events.fire((Object)new WorkflowEvent(this.data, 1));
        } else {
            logger.warning("Missing CDI support for Event<WorkflowEvent> !");
        }
        logger.finest("......document created");
    }

    public void save() throws AccessDeniedException {
        if (this.events != null) {
            this.events.fire((Object)new WorkflowEvent(this.data, 4));
        } else {
            logger.warning("Missing CDI support for Event<WorkflowEvent> !");
        }
        this.data = this.documentService.save(this.data);
        if (this.events != null) {
            this.events.fire((Object)new WorkflowEvent(this.data, 5));
        }
        this.close();
        logger.finest("......ItemCollection saved");
    }

    public void delete(String uniqueID) throws AccessDeniedException {
        ItemCollection _workitem = this.documentService.load(uniqueID);
        if (_workitem != null) {
            if (this.events != null) {
                this.events.fire((Object)new WorkflowEvent(this.getDocument(), 6));
            } else {
                logger.warning("Missing CDI support for Event<WorkflowEvent> !");
            }
            this.documentService.remove(_workitem);
            if (this.events != null) {
                this.events.fire((Object)new WorkflowEvent(this.getDocument(), 7));
            }
            this.setDocument(null);
            logger.fine("......document " + uniqueID + " deleted");
        } else {
            logger.fine("......document '" + uniqueID + "' not found (null)");
        }
    }

    @Override
    public void load(String uniqueid) {
        super.load(uniqueid);
        if (this.data != null && this.events != null) {
            this.events.fire((Object)new WorkflowEvent(this.data, 3));
        }
    }
}

