/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.faces.util;

import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.imixs.workflow.engine.DocumentService;

@Named
@RequestScoped
public class LoginController {
    @Inject
    private DocumentService documentService;

    public boolean isAuthenticated() {
        if (this.getUserPrincipal() == null) {
            return false;
        }
        ExternalContext ectx = FacesContext.getCurrentInstance().getExternalContext();
        if (ectx.isUserInRole("org.imixs.ACCESSLEVEL.AUTHORACCESS")) {
            return true;
        }
        if (ectx.isUserInRole("org.imixs.ACCESSLEVEL.EDITORACCESS")) {
            return true;
        }
        if (ectx.isUserInRole("org.imixs.ACCESSLEVEL.MANAGERACCESS")) {
            return true;
        }
        return ectx.isUserInRole("org.imixs.ACCESSLEVEL.READERACCESS");
    }

    public boolean isUserInRole(String aRoleName) {
        ExternalContext ectx = FacesContext.getCurrentInstance().getExternalContext();
        if (aRoleName == null || aRoleName.isEmpty()) {
            return false;
        }
        return ectx.isUserInRole(aRoleName);
    }

    public String getUserPrincipal() {
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext externalContext = context.getExternalContext();
        return externalContext.getUserPrincipal() != null ? externalContext.getUserPrincipal().getName() : null;
    }

    public String getRemoteUser() {
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext externalContext = context.getExternalContext();
        String remoteUser = externalContext.getRemoteUser();
        return remoteUser;
    }

    public List<String> getUserNameList() {
        return this.documentService.getUserNameList();
    }

    public String getServerURI() {
        HttpServletRequest servletRequest = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
        String port = "" + servletRequest.getLocalPort();
        String server = servletRequest.getServerName();
        return "http://" + server + ":" + port + "";
    }

    public void doLogout(ActionEvent event) {
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext externalContext = context.getExternalContext();
        HttpSession session = (HttpSession)externalContext.getSession(false);
        session.invalidate();
    }
}

