/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.faces.fileupload;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.enterprise.context.Conversation;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.event.Observes;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.faces.data.WorkflowEvent;

@Named
@ConversationScoped
public class FileUploadController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ItemCollection workitem = null;
    private List<FileData> _tmpFiles = null;
    private List<FileData> _persistedFiles = null;
    private static Logger logger = Logger.getLogger(FileUploadController.class.getName());
    @Inject
    private Conversation conversation;

    public ItemCollection getWorkitem() {
        return this.workitem;
    }

    public void setWorkitem(ItemCollection workitem) {
        this.workitem = workitem;
        if (workitem != null) {
            if (this.conversation.isTransient()) {
                this.conversation.setTimeout((long)(((HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest()).getSession().getMaxInactiveInterval() * 1000));
                this.conversation.begin();
                logger.finest("......starting new conversation, id=" + this.conversation.getId());
            }
            this.reset();
            for (FileData fileData : workitem.getFileData()) {
                this._persistedFiles.add(fileData);
            }
        }
    }

    public String getCID() {
        if (this.conversation != null) {
            return this.conversation.getId();
        }
        return "";
    }

    public void onWorkflowEvent(@Observes WorkflowEvent workflowEvent) {
        if (workflowEvent == null) {
            return;
        }
        if (20 == workflowEvent.getEventType()) {
            this.reset();
        }
    }

    public void addAttachedFile(FileData filedata) {
        if (this.workitem != null) {
            this._tmpFiles.add(filedata);
            this.workitem.addFileData(filedata);
        }
    }

    public void removeAttachedFile(String aFilename) {
        if (this.workitem != null) {
            this.workitem.removeFile(aFilename);
            Iterator<FileData> iterator = this._tmpFiles.iterator();
            while (iterator.hasNext()) {
                FileData tmp = iterator.next();
                if (!tmp.getName().equals(aFilename)) continue;
                iterator.remove();
            }
        }
    }

    public void removePersistedFile(String aFilename) {
        if (this.workitem != null) {
            this.workitem.removeFile(aFilename);
        }
        Iterator<FileData> iterator = this._persistedFiles.iterator();
        while (iterator.hasNext()) {
            FileData tmp = iterator.next();
            if (!tmp.getName().equals(aFilename)) continue;
            iterator.remove();
        }
    }

    public List<FileData> getAttachedFiles() {
        if (this._tmpFiles == null) {
            this._tmpFiles = new ArrayList<FileData>();
        }
        return this._tmpFiles;
    }

    public List<FileData> getPersistedFiles() {
        if (this._persistedFiles == null) {
            this._persistedFiles = new ArrayList<FileData>();
        }
        return this._persistedFiles;
    }

    public void reset() {
        this._tmpFiles = new ArrayList<FileData>();
        this._persistedFiles = new ArrayList<FileData>();
    }

    public String getFileSize(String aFilename) {
        if (this.workitem != null) {
            List sizeAttribute;
            FileData fileData = this.workitem.getFileData(aFilename);
            double bytes = fileData.getContent().length;
            if (bytes == 0.0 && (sizeAttribute = (List)fileData.getAttribute("size")) != null && sizeAttribute.size() > 0) {
                try {
                    bytes = Double.parseDouble(sizeAttribute.get(0).toString());
                }
                catch (NumberFormatException n) {
                    logger.warning("unable to parse size attribute in FileData for file '" + aFilename + "'");
                }
            }
            if (bytes >= 1.0E9) {
                return FileUploadController.round(bytes /= 1.0E9) + " GB";
            }
            if (bytes >= 1000000.0) {
                return FileUploadController.round(bytes /= 1000000.0) + " MB";
            }
            if (bytes >= 1000.0) {
                return FileUploadController.round(bytes /= 1000.0) + " KB";
            }
            return FileUploadController.round(bytes) + " bytes";
        }
        return "";
    }

    public static double round(double value) {
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(2, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }
}

