/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.faces.data;

import jakarta.enterprise.context.Conversation;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.context.FacesContext;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;

public abstract class AbstractDataController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(AbstractDataController.class.getName());
    private String defaultType;
    @Inject
    private Conversation conversation;
    protected ItemCollection data = null;
    @Inject
    private DocumentService documentService;

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public String getDefaultType() {
        return this.defaultType;
    }

    public void setDefaultType(String type) {
        this.defaultType = type;
    }

    public void reset() {
        this.data = new ItemCollection();
        this.data.replaceItemValue("type", (Object)this.getDefaultType());
    }

    public boolean isNewWorkitem() {
        if (this.data == null) {
            return false;
        }
        Date created = this.data.getItemValueDate("$created");
        Date modified = this.data.getItemValueDate("$modified");
        return modified == null || created == null;
    }

    public void addMessage(String ressourceBundleName, String messageKey, Object param) {
        String msgPattern;
        FacesContext context = FacesContext.getCurrentInstance();
        Locale locale = context.getViewRoot().getLocale();
        ResourceBundle rb = ResourceBundle.getBundle(ressourceBundleName, locale);
        String msg = msgPattern = rb.getString(messageKey);
        if (param != null) {
            Object[] params = new Object[]{param};
            msg = MessageFormat.format(msgPattern, params);
        }
        FacesMessage facesMsg = new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, msg);
        context.addMessage(null, facesMsg);
    }

    public void onLoad() {
        logger.finest("......onload...");
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (!facesContext.isPostback() && !facesContext.isValidationFailed()) {
            FacesContext fc = FacesContext.getCurrentInstance();
            Map paramMap = fc.getExternalContext().getRequestParameterMap();
            String uniqueid = (String)paramMap.get("id");
            if (uniqueid == null || uniqueid.isEmpty()) {
                uniqueid = (String)paramMap.get("workitem");
            }
            this.load(uniqueid);
        }
    }

    public void load(String uniqueid) {
        if (uniqueid != null && !uniqueid.isEmpty()) {
            logger.log(Level.FINEST, "......load uniqueid={0}", uniqueid);
            this.data = this.documentService.load(uniqueid);
            if (this.data == null) {
                this.data = new ItemCollection();
            }
            this.startConversation();
        }
    }

    public void close() {
        if (!this.conversation.isTransient()) {
            logger.log(Level.FINEST, "......stopping conversation, id={0}", this.conversation.getId());
            this.conversation.end();
        }
    }

    protected void startConversation() {
        if (this.conversation.isTransient()) {
            this.conversation.setTimeout((long)(((HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest()).getSession().getMaxInactiveInterval() * 1000));
            this.conversation.begin();
            logger.log(Level.FINEST, "......start new conversation, id={0}", this.conversation.getId());
        }
    }
}

