/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.faces.util;

import jakarta.faces.application.FacesMessage;
import jakarta.faces.context.FacesContext;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.imixs.workflow.engine.plugins.RulePlugin;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.WorkflowException;
import org.imixs.workflow.faces.util.ValidationException;

public class ErrorHandler {
    private static final Logger logger = Logger.getLogger(ErrorHandler.class.getName());

    public static void handlePluginException(PluginException pe) {
        if (RulePlugin.class.getName().equals(pe.getErrorContext()) && "VALIDATION_ERROR".equals(pe.getErrorCode()) && pe.getErrorParameters() != null && pe.getErrorParameters().length > 0) {
            Object[] messages;
            String errorCode = pe.getErrorCode();
            try {
                Locale browserLocale = FacesContext.getCurrentInstance().getViewRoot().getLocale();
                ResourceBundle rb = ResourceBundle.getBundle("bundle.app", browserLocale);
                errorCode = rb.getString(pe.getErrorCode());
            }
            catch (MissingResourceException mre) {
                logger.log(Level.WARNING, "ErrorHandler: {0}", mre.getMessage());
            }
            for (Object aMessage : messages = pe.getErrorParameters()) {
                FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, errorCode, aMessage.toString()));
            }
        } else {
            ErrorHandler.addErrorMessage((WorkflowException)pe);
        }
        logger.log(Level.WARNING, "ErrorHandler cauth PluginException - error code={0} - {1}", new Object[]{pe.getErrorCode(), pe.getMessage()});
        if (logger.isLoggable(Level.FINE)) {
            pe.printStackTrace();
        }
    }

    public static void handleModelException(ModelException me) {
        String message = me.getErrorCode();
        try {
            Locale browserLocale = FacesContext.getCurrentInstance().getViewRoot().getLocale();
            ResourceBundle rb = ResourceBundle.getBundle("bundle.app", browserLocale);
            message = rb.getString(me.getErrorCode());
        }
        catch (MissingResourceException mre) {
            logger.log(Level.WARNING, "ErrorHandler: {0}", mre.getMessage());
        }
        FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, message, me.getMessage()));
        logger.log(Level.WARNING, "ErrorHandler cauth ModelException - error code={0} - {1}", new Object[]{me.getErrorCode(), me.getMessage()});
        if (logger.isLoggable(Level.FINE)) {
            me.printStackTrace();
        }
    }

    public static void addErrorMessage(WorkflowException pe) {
        Object p;
        String errorCode = pe.getErrorCode();
        String message = pe.getMessage();
        try {
            String messageFromBundle = ErrorHandler.getMessageFromBundle(pe.getErrorCode());
            if (messageFromBundle != null && !messageFromBundle.isEmpty()) {
                message = messageFromBundle;
            }
        }
        catch (MissingResourceException mre) {
            logger.log(Level.WARNING, "ErrorHandler: {0}", mre.getMessage());
        }
        if (pe instanceof PluginException) {
            p = (PluginException)pe;
            if (p.getErrorParameters() != null && p.getErrorParameters().length > 0) {
                for (int i = 0; i < p.getErrorParameters().length; ++i) {
                    message = message.replace("{" + i + "}", p.getErrorParameters()[i].toString());
                }
            }
        } else if (pe instanceof ValidationException && ((ValidationException)((Object)(p = (ValidationException)pe))).getErrorParameters() != null && ((ValidationException)((Object)p)).getErrorParameters().length > 0) {
            for (int i = 0; i < ((ValidationException)((Object)p)).getErrorParameters().length; ++i) {
                message = message.replace("{" + i + "}", ((ValidationException)((Object)p)).getErrorParameters()[i].toString());
            }
        }
        FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, errorCode, message));
    }

    private static String getMessageFromBundle(String messageFromBundle) {
        String result = "";
        if (messageFromBundle != null && !messageFromBundle.isEmpty()) {
            Locale browserLocale = FacesContext.getCurrentInstance().getViewRoot().getLocale();
            try {
                ResourceBundle rb = ResourceBundle.getBundle("bundle.custom", browserLocale);
                if (rb != null) {
                    result = rb.getString(messageFromBundle);
                }
                if ((result == null || result.isEmpty()) && (rb = ResourceBundle.getBundle("bundle.app", browserLocale)) != null) {
                    result = rb.getString(messageFromBundle);
                }
            }
            catch (MissingResourceException mre) {
                logger.log(Level.WARNING, "ErrorHandler: {0}", mre.getMessage());
            }
        }
        return result;
    }
}

