/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.faces.util;

import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.RequestScoped;
import jakarta.faces.context.FacesContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Named
@RequestScoped
public class ResourceBundleHandler {
    private Locale browserLocale = null;
    private List<ResourceBundle> resourceBundleList = null;
    @Inject
    @ConfigProperty(name="resourcebundle.names", defaultValue="bundle.messages,bundle.app,bundle.custom")
    String bundNameProperty;

    @PostConstruct
    public void init() {
        String[] bundleNameList;
        this.resourceBundleList = new ArrayList<ResourceBundle>();
        this.browserLocale = FacesContext.getCurrentInstance().getViewRoot().getLocale();
        for (String bundleName : bundleNameList = this.bundNameProperty.split(",")) {
            ResourceBundle bundle = null;
            try {
                bundle = ResourceBundle.getBundle(bundleName, this.browserLocale);
                if (bundle == null) continue;
                this.resourceBundleList.add(bundle);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
    }

    public Locale getBrowserLocale() {
        return this.browserLocale;
    }

    public ResourceBundle getMessagesBundleByName(String name) {
        for (ResourceBundle rb : this.resourceBundleList) {
            if (!rb.getBaseBundleName().equals(name) && !rb.getBaseBundleName().endsWith(name)) continue;
            return rb;
        }
        return null;
    }

    public String get(String key) {
        return this.findMessage(key);
    }

    public String findMessage(String key) {
        ListIterator<ResourceBundle> listIterator = this.resourceBundleList.listIterator(this.resourceBundleList.size());
        while (listIterator.hasPrevious()) {
            ResourceBundle bundle = listIterator.previous();
            try {
                String messageFromBundle = bundle.getString(key);
                if (messageFromBundle == null || messageFromBundle.isEmpty()) continue;
                return messageFromBundle;
            }
            catch (MissingResourceException missingResourceException) {
            }
        }
        return "";
    }
}

